/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.compiler;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import jdk.test.lib.compiler.CompilerUtils;

public class ModuleInfoMaker {
    private static final String MODULE_INFO_JAVA = "module-info.java";
    private static final Pattern MODULE_PATTERN = Pattern.compile("module\\s+((?:\\w+\\.)*)");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+(((?:\\w+\\.)*)(?:\\w+))");
    private static final Pattern CLASS_PATTERN = Pattern.compile("(?:public\\s+)?(?:class|enum|interface)\\s+(\\w+)");
    private final Path dir;

    public ModuleInfoMaker(Path dir) {
        this.dir = dir;
    }

    public void writeJavaFiles(String module, String moduleInfoJava, String ... contents) throws IOException {
        Path msrc = this.dir.resolve(module);
        new JavaSource(moduleInfoJava).write(msrc);
        for (String c : contents) {
            new JavaSource(c).write(msrc);
        }
    }

    public void compile(String module, Path dest, String ... options) throws IOException {
        Path msrc = this.dir.resolve(module);
        String[] args = (String[])Stream.concat(Arrays.stream(options), Stream.of("--module-source-path", this.dir.toString())).toArray(String[]::new);
        if (!CompilerUtils.compile(msrc, dest, args)) {
            throw new Error("Fail to compile " + module);
        }
    }

    static class JavaSource {
        final String source;

        JavaSource(String source) {
            this.source = source;
        }

        public void write(Path dir) throws IOException {
            Path file = dir.resolve(JavaSource.getJavaFileNameFromSource(this.source));
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (BufferedWriter out = Files.newBufferedWriter(file, new OpenOption[0]);){
                out.write(this.source.replace("\n", System.lineSeparator()));
            }
        }

        static String getJavaFileNameFromSource(String source) {
            String packageName = null;
            Matcher matcher = MODULE_PATTERN.matcher(source);
            if (matcher.find()) {
                return ModuleInfoMaker.MODULE_INFO_JAVA;
            }
            matcher = PACKAGE_PATTERN.matcher(source);
            if (matcher.find()) {
                packageName = matcher.group(1).replace(".", "/");
            }
            if ((matcher = CLASS_PATTERN.matcher(source)).find()) {
                String className = matcher.group(1) + ".java";
                return packageName == null ? className : packageName + "/" + className;
            }
            if (packageName != null) {
                return packageName + "/package-info.java";
            }
            throw new Error("Could not extract the java class name from the provided source");
        }
    }
}

