/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.nebula.nattable.finder.widgets;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.coordinate.PixelCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.nebula.nattable.finder.finders.NatTableContextMenuFinder;
import org.eclipse.swtbot.nebula.nattable.finder.widgets.Position;
import org.eclipse.swtbot.swt.finder.ReferenceBy;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.hamcrest.SelfDescribing;

@SWTBotWidget(clasz=NatTable.class, preferredName="NatTable", referenceBy={ReferenceBy.LABEL})
public class SWTBotNatTable
extends AbstractSWTBot<NatTable> {
    public SWTBotNatTable(NatTable natTable) throws WidgetNotFoundException {
        this(natTable, null);
    }

    public SWTBotNatTable(NatTable natTable, SelfDescribing description) throws WidgetNotFoundException {
        super((Widget)natTable, description);
    }

    public int rowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getRowCount();
            }
        });
    }

    public int preferredRowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getPreferredRowCount();
            }
        });
    }

    public int columnCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getColumnCount();
            }
        });
    }

    public int preferredColumnCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((NatTable)SWTBotNatTable.this.widget).getPreferredColumnCount();
            }
        });
    }

    public SWTBotNatTable click(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.waitForEnabled();
        this.setFocus();
        this.syncExec(new VoidResult(){

            public void run() {
                Rectangle cellBounds = ((NatTable)SWTBotNatTable.this.widget).getBoundsByPosition(column, row);
                SWTBotNatTable.this.clickXY(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
            }
        });
        return this;
    }

    public SWTBotNatTable doubleclick(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.setFocus();
        this.syncExec(new VoidResult(){

            public void run() {
                Rectangle cellBounds = ((NatTable)SWTBotNatTable.this.widget).getBoundsByPosition(column, row);
                SWTBotNatTable.this.doubleClickXY(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
            }
        });
        return this;
    }

    public SWTBotNatTable rightClick(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.setFocus();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Rectangle cellBounds = ((NatTable)SWTBotNatTable.this.widget).getBoundsByPosition(column, row);
                SWTBotNatTable.this.rightClick(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2, false);
            }
        });
        return this;
    }

    public SWTBotNatTable rightClick() {
        this.setFocus();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Rectangle widgetBounds = ((NatTable)SWTBotNatTable.this.widget).getBounds();
                SWTBotNatTable.this.rightClick(widgetBounds.width / 2, widgetBounds.height / 2, false);
            }
        });
        return this;
    }

    protected Rectangle widgetBounds() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((NatTable)SWTBotNatTable.this.widget).getBounds();
            }
        });
    }

    protected SWTBotRootMenu contextMenu(Control control) throws WidgetNotFoundException {
        this.waitForEnabled();
        Rectangle location = this.widgetBounds();
        return NatTableContextMenuFinder.contextMenu((Control)this.widget, location.width / 2, location.height / 2);
    }

    public SWTBotRootMenu contextMenu(int row, int column) throws WidgetNotFoundException {
        this.assertIsLegalCell(row, column);
        this.waitForEnabled();
        Rectangle location = ((NatTable)this.widget).getBoundsByPosition(column, row);
        return NatTableContextMenuFinder.contextMenu((Control)this.widget, location.x + location.width / 2, location.y + location.height / 2);
    }

    protected void assertIsLegalCell(int row, int column) {
        int rowCount = this.rowCount();
        int columnCount = this.columnCount();
        Assert.isLegal((row >= 0 ? 1 : 0) != 0, (Object)("The row number (" + row + ") is out of bounds"));
        Assert.isLegal((column >= 0 ? 1 : 0) != 0, (Object)("The column number (" + column + ") is out of bounds"));
        Assert.isLegal((row < rowCount ? 1 : 0) != 0, (Object)("The row number (" + row + ") is more than the number of visible rows (" + rowCount + ") in the NatTable."));
        Assert.isLegal((column < columnCount || columnCount == 0 && column == 0 ? 1 : 0) != 0, (Object)("The column number (" + column + ") is more than the number of visible columns (" + columnCount + ") in the NatTable."));
    }

    public String getCellDataValueByPosition(int row, int column) {
        this.assertIsLegalCell(row, column);
        Object obj = ((NatTable)this.widget).getDataValueByPosition(column, row);
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public String getCellDataValueByPosition(Position position) {
        return this.getCellDataValueByPosition(position.row, position.column);
    }

    public void setCellDataValueByPosition(final int row, final int column, final String text) {
        this.assertIsLegalCell(row, column);
        Assert.isNotNull((Object)text);
        this.waitForEnabled();
        Assert.isTrue((!this.hasStyle(this.widget, 8) ? 1 : 0) != 0);
        this.asyncExec(new VoidResult(){

            public void run() {
                SWTBotNatTable.this.click(row, column);
                ICellEditor editor = ((NatTable)SWTBotNatTable.this.widget).getActiveCellEditor();
                editor.setEditorValue((Object)text);
            }
        });
        this.notify(24);
    }

    private ViewportLayer getViewportLayer(Position position) {
        ILayer layer = ((NatTable)this.widget).getLayer();
        while (layer != null) {
            if (layer instanceof ViewportLayer) {
                return (ViewportLayer)layer;
            }
            ILayer underlyingLayer = layer.getUnderlyingLayerByPosition(position.column, position.row);
            position.column = layer.localToUnderlyingColumnPosition(position.column);
            position.row = layer.localToUnderlyingRowPosition(position.row);
            layer = underlyingLayer;
        }
        return null;
    }

    public Position scrollViewport(Position position, int scrollableRow, int scrollableColumn) {
        Position viewportPosition = new Position(position);
        ViewportLayer viewportLayer = this.getViewportLayer(viewportPosition);
        this.assertIsValidLayer((ILayer)viewportLayer, "viewport layer", position);
        ILayer scrollableLayer = viewportLayer.getUnderlyingLayerByPosition(viewportPosition.column, viewportPosition.row);
        if (scrollableColumn < 0 || scrollableColumn >= scrollableLayer.getColumnCount() || scrollableRow < 0 || scrollableRow >= scrollableLayer.getRowCount()) {
            throw new IllegalArgumentException("Scrollable position " + new Position(scrollableRow, scrollableColumn) + " is out of range.");
        }
        Position underlyingPosition = new Position(viewportLayer.localToUnderlyingRowPosition(viewportPosition.row), viewportLayer.localToUnderlyingColumnPosition(viewportPosition.column));
        Rectangle underlyingBounds = scrollableLayer.getBoundsByPosition(underlyingPosition.column, underlyingPosition.row);
        Rectangle desiredBounds = scrollableLayer.getBoundsByPosition(scrollableColumn, scrollableRow);
        PixelCoordinate pixelOffset = new PixelCoordinate(desiredBounds.x - underlyingBounds.x, desiredBounds.y - underlyingBounds.y);
        PixelCoordinate origin = viewportLayer.getOrigin();
        viewportLayer.setOriginX(origin.getX() + pixelOffset.getX());
        viewportLayer.setOriginY(origin.getY() + pixelOffset.getY());
        Position newUnderlyingPosition = new Position(viewportLayer.localToUnderlyingRowPosition(viewportPosition.row), viewportLayer.localToUnderlyingColumnPosition(viewportPosition.column));
        Position offset = new Position(scrollableRow - newUnderlyingPosition.row, scrollableColumn - newUnderlyingPosition.column);
        return new Position(position.row + offset.row, position.column + offset.column);
    }

    public Position scrollToRowHeader(Position position, int scrollableRow, int headerColumn) {
        Position viewportPosition = new Position(position);
        ViewportLayer viewportLayer = this.getViewportLayer(viewportPosition);
        this.assertIsValidLayer((ILayer)viewportLayer, "viewport layer", position);
        int scrollableColumn = viewportLayer.localToUnderlyingColumnPosition(viewportPosition.column);
        int row = this.scrollViewport((Position)position, (int)scrollableRow, (int)scrollableColumn).row;
        return new Position(row, headerColumn);
    }

    public Position scrollToColumnHeader(Position position, int headerRow, int scrollableColumn) {
        Position viewportPosition = new Position(position);
        ViewportLayer viewportLayer = this.getViewportLayer(viewportPosition);
        this.assertIsValidLayer((ILayer)viewportLayer, "viewport layer", position);
        int scrollableRow = viewportLayer.localToUnderlyingRowPosition(viewportPosition.row);
        int column = this.scrollViewport((Position)position, (int)scrollableRow, (int)scrollableColumn).column;
        return new Position(headerRow, column);
    }

    public boolean hasConfigLabel(int row, int column, String label) {
        this.assertIsLegalCell(row, column);
        LabelStack labels = ((NatTable)this.widget).getConfigLabelsByPosition(column, row);
        return labels.hasLabel(label);
    }

    private TreeLayer getTreeLayer(Position position) {
        Position modifiedPosition = new Position(position);
        ILayer layer = ((NatTable)this.widget).getLayer();
        while (layer != null) {
            if (layer instanceof TreeLayer) {
                return (TreeLayer)layer;
            }
            ILayer underlyingLayer = layer.getUnderlyingLayerByPosition(modifiedPosition.column, modifiedPosition.row);
            modifiedPosition.column = layer.localToUnderlyingColumnPosition(modifiedPosition.column);
            modifiedPosition.row = layer.localToUnderlyingRowPosition(modifiedPosition.row);
            layer = underlyingLayer;
        }
        return null;
    }

    private void assertIsValidLayer(ILayer layer, String layerName, Position position) {
        if (layer == null) {
            throw new IllegalArgumentException("No " + layerName + " found at position " + position);
        }
    }

    private void assertIsValidRow(int row, ILayer layer, String layerName) {
        if (row < 0 || row >= layer.getRowCount()) {
            throw new IllegalArgumentException("Row " + row + " is out of range for " + layerName);
        }
    }

    public void expandAll(Position position) {
        final TreeLayer treelayer = this.getTreeLayer(position);
        this.assertIsValidLayer((ILayer)treelayer, "TreeLayer", position);
        this.syncExec(new VoidResult(){

            public void run() {
                treelayer.expandAll();
            }
        });
    }

    public void collapseAll(Position position) {
        final TreeLayer treelayer = this.getTreeLayer(position);
        this.assertIsValidLayer((ILayer)treelayer, "TreeLayer", position);
        this.syncExec(new VoidResult(){

            public void run() {
                treelayer.collapseAll();
            }
        });
    }

    public void collapseTreeRow(Position position, final int treeRow) {
        final TreeLayer treelayer = this.getTreeLayer(position);
        this.assertIsValidLayer((ILayer)treelayer, "TreeLayer", position);
        this.assertIsValidRow(treeRow, (ILayer)treelayer, "TreeLayer");
        this.syncExec(new VoidResult(){

            public void run() {
                treelayer.collapseTreeRow(treeRow);
            }
        });
    }

    public void expandTreeRow(Position position, final int treeRow) {
        final TreeLayer treelayer = this.getTreeLayer(position);
        this.assertIsValidLayer((ILayer)treelayer, "TreeLayer", position);
        this.assertIsValidRow(treeRow, (ILayer)treelayer, "TreeLayer");
        this.syncExec(new VoidResult(){

            public void run() {
                treelayer.expandTreeRow(treeRow);
            }
        });
    }

    public void expandTreeRowToLevel(Position position, final int treeRow, final int level) {
        final TreeLayer treelayer = this.getTreeLayer(position);
        this.assertIsValidLayer((ILayer)treelayer, "TreeLayer", position);
        this.assertIsValidRow(treeRow, (ILayer)treelayer, "TreeLayer");
        Assert.isLegal((level > 0 ? 1 : 0) != 0, (Object)"Level should be greater than 0");
        this.syncExec(new VoidResult(){

            public void run() {
                treelayer.expandTreeRowToLevel(treeRow, level);
            }
        });
    }

    public void expandAllToLevel(Position position, final int level) {
        final TreeLayer treelayer = this.getTreeLayer(position);
        this.assertIsValidLayer((ILayer)treelayer, "TreeLayer", position);
        Assert.isLegal((level > 0 ? 1 : 0) != 0, (Object)"Level should be greater than 0");
        this.syncExec(new VoidResult(){

            public void run() {
                treelayer.expandAllToLevel(level);
            }
        });
    }

    public void expandOrCollapseIndex(Position position, final int treeRow) {
        final TreeLayer treelayer = this.getTreeLayer(position);
        this.assertIsValidLayer((ILayer)treelayer, "TreeLayer", position);
        this.assertIsValidRow(treeRow, (ILayer)treelayer, "TreeLayer");
        this.syncExec(new VoidResult(){

            public void run() {
                treelayer.expandOrCollapseIndex(treeRow);
            }
        });
    }
}

