/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.refactor;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNResourceRuleFactory;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CopyResourceFromHookOperation
extends AbstractActionOperation {
    protected IResource source;
    protected IResource destination;
    protected int options;

    public CopyResourceFromHookOperation(IResource source, IResource destination, int options) {
        super("Operation_CopyResourceFromHook", SVNMessages.class);
        this.source = source;
        this.destination = destination;
        this.options = options;
    }

    public ISchedulingRule getSchedulingRule() {
        return SVNResourceRuleFactory.INSTANCE.copyRule(this.source, this.destination);
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.source.getName(), this.destination.toString()});
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource toResource = this.destination;
        if (toResource instanceof IContainer && (toResource = toResource.getParent()) == null) {
            String errMessage = SVNMessages.formatErrorString("Error_NoParent", new String[]{this.destination.getFullPath().toString()});
            throw new UnreportableException(errMessage);
        }
        FileUtility.copyAll(new File(FileUtility.getWorkingCopyPath(toResource)), new File(FileUtility.getWorkingCopyPath(this.source)), this.options, new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().equals(SVNUtility.getSVNFolderName());
            }
        }, monitor);
    }
}

