/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.dialogs;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class SelectSupplementaryResourcesDialog
extends Dialog {
    private CheckboxTreeViewer fTreeViewer;
    private final IResource[] fAvailableResources;
    private IResource[] fReturndResources;

    public SelectSupplementaryResourcesDialog(Shell shell, IResource[] resources) {
        super(shell);
        this.fAvailableResources = Arrays.copyOf(resources, resources.length);
        this.setShellStyle(16);
    }

    public IResource[] getResources() {
        return Arrays.copyOf(this.fReturndResources, this.fReturndResources.length);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectSpplementaryResources_DialogTitle);
        newShell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group contextGroup = new Group(composite, 32);
        contextGroup.setText(Messages.SelectSpplementaryResources_ResourcesGroupTitle);
        contextGroup.setLayout((Layout)new GridLayout());
        contextGroup.setLayoutData((Object)new GridData(1808));
        this.fTreeViewer = new CheckboxTreeViewer((Composite)contextGroup, 770);
        GridData data = new GridData(1808);
        Tree tree = this.fTreeViewer.getTree();
        tree.setLayoutData((Object)data);
        this.fTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return element instanceof IResource[];
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IResource[]) {
                    return (Object[])parentElement;
                }
                return null;
            }
        });
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IResource) {
                    IResource resource = (IResource)element;
                    return String.valueOf(resource.getParent().getName()) + File.separator + resource.getName();
                }
                return super.getText(element);
            }
        });
        this.fTreeViewer.setInput((Object)this.fAvailableResources);
        this.getShell().setMinimumSize(new Point(300, 150));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        Object[] checked = this.fTreeViewer.getCheckedElements();
        this.fReturndResources = new IResource[checked.length];
        int i = 0;
        while (i < checked.length) {
            this.fReturndResources[i] = (IResource)checked[i];
            ++i;
        }
        super.okPressed();
    }
}

