/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace;

import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;

public class TmfExperimentCheckpoint
implements Comparable<TmfExperimentCheckpoint> {
    private final TmfTimestamp fTimestamp;
    private final long[] fRanks;

    public TmfExperimentCheckpoint(TmfTimestamp ts, TmfContext[] contexts) {
        this.fTimestamp = ts;
        this.fRanks = new long[contexts.length];
        int i = 0;
        while (i < this.fRanks.length) {
            this.fRanks[i] = contexts[i].getRank();
            ++i;
        }
    }

    public TmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    public long[] getRanks() {
        return this.fRanks;
    }

    public int hashCode() {
        int result = 37;
        result = 17 * result + this.fTimestamp.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfExperimentCheckpoint)) {
            return false;
        }
        TmfExperimentCheckpoint o = (TmfExperimentCheckpoint)other;
        return this.fTimestamp.equals(o.fTimestamp);
    }

    @Override
    public int compareTo(TmfExperimentCheckpoint other) {
        return this.fTimestamp.compareTo(other.fTimestamp, false);
    }
}

