/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tools.launch.core.factory;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.tools.launch.core.factory.LinuxtoolsProcessFactory;

public class RuntimeProcessFactory
extends LinuxtoolsProcessFactory {
    private static RuntimeProcessFactory instance = null;
    private static final String WHICH_CMD = "which";

    private String[] tokenizeCommand(String command) {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            cmdarray[i] = tokenizer.nextToken();
            ++i;
        }
        return cmdarray;
    }

    private String[] fillPathCommand(String[] cmdarray, String[] envp) throws IOException {
        cmdarray[0] = this.whichCommand(cmdarray[0], envp);
        return cmdarray;
    }

    private String[] fillPathSudoCommand(String[] cmdarray, String[] envp) throws IOException {
        cmdarray[2] = this.whichCommand(cmdarray[2], envp);
        return cmdarray;
    }

    public String whichCommand(String command, IProject project) throws IOException {
        return this.whichCommand(command, this.updateEnvironment(null, project));
    }

    public String whichCommand(String command, String[] envp) throws IOException {
        Process p = Runtime.getRuntime().exec(new String[]{WHICH_CMD, command}, envp);
        try {
            if (p.waitFor() != 0) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                throw new IOException(reader.readLine());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            command = reader.readLine();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return command;
    }

    public static RuntimeProcessFactory getFactory() {
        if (instance == null) {
            instance = new RuntimeProcessFactory();
        }
        return instance;
    }

    public Process exec(String cmd, IProject project) throws IOException {
        return this.exec(cmd, null, null, project);
    }

    public Process exec(String[] cmdarray, IProject project) throws IOException {
        return this.exec(cmdarray, null, project);
    }

    public Process exec(String[] cmdarray, String[] envp, IProject project) throws IOException {
        return this.exec(cmdarray, envp, null, project);
    }

    public Process exec(String cmd, String[] envp, IProject project) throws IOException {
        return this.exec(cmd, envp, null, project);
    }

    public Process exec(String cmd, String[] envp, File dir, IProject project) throws IOException {
        return this.exec(this.tokenizeCommand(cmd), envp, dir, project);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir, IProject project) throws IOException {
        envp = this.updateEnvironment(envp, project);
        cmdarray = this.fillPathCommand(cmdarray, envp);
        return Runtime.getRuntime().exec(cmdarray, envp, dir);
    }

    public Process sudoExec(String cmd, IProject project) throws IOException {
        return this.sudoExec(cmd, null, null, project);
    }

    public Process sudoExec(String cmd, String[] envp, IProject project) throws IOException {
        return this.exec(cmd, envp, null, project);
    }

    public Process sudoExec(String cmd, String[] envp, File dir, IProject project) throws IOException {
        return this.sudoExec(this.tokenizeCommand(cmd), envp, dir, project);
    }

    public Process sudoExec(String[] cmdarray, IProject project) throws IOException {
        return this.sudoExec(cmdarray, null, project);
    }

    public Process sudoExec(String[] cmdarray, String[] envp, IProject project) throws IOException {
        return this.sudoExec(cmdarray, envp, null, project);
    }

    public Process sudoExec(String[] cmdarray, String[] envp, File dir, IProject project) throws IOException {
        List<String> cmdList = Arrays.asList(cmdarray);
        ArrayList<String> cmdArrayList = new ArrayList<String>(cmdList);
        cmdArrayList.add(0, "sudo");
        cmdArrayList.add(1, "-n");
        String[] cmdArraySudo = new String[cmdArrayList.size()];
        cmdArrayList.toArray(cmdArraySudo);
        envp = this.updateEnvironment(envp, project);
        cmdArraySudo = this.fillPathSudoCommand(cmdArraySudo, envp);
        return Runtime.getRuntime().exec(cmdArraySudo, envp, dir);
    }
}

