/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.cdt.libhover.devhelp.DevHelpPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpTopic;

public class DevHelpToc
implements IToc {
    public String getLabel() {
        return "Devhelp Documents";
    }

    public String getHref() {
        return null;
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getTopics();
    }

    public ITopic[] getTopics() {
        try {
            ArrayList<DevHelpTopic> topics = new ArrayList<DevHelpTopic>();
            IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
            Path devhelpLocation = new Path(ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory"));
            IFileSystem fs = EFS.getLocalFileSystem();
            IFileStore htmlDir = fs.getStore((IPath)devhelpLocation);
            IFileStore[] files = htmlDir.childStores(0, null);
            Arrays.sort(files, new Comparator<IFileStore>(){

                @Override
                public int compare(IFileStore arg0, IFileStore arg1) {
                    return arg0.getName().compareToIgnoreCase(arg1.getName());
                }
            });
            IFileStore[] iFileStoreArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore file = iFileStoreArray[n2];
                String name = file.fetchInfo().getName();
                DevHelpTopic topic = new DevHelpTopic(name);
                topics.add(topic);
                ++n2;
            }
            ITopic[] retval = new ITopic[topics.size()];
            return topics.toArray(retval);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public ITopic getTopic(String href) {
        return null;
    }
}

