/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.parsers.custom;

import java.util.LinkedList;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomEvent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.linuxtools.tmf.ui.widgets.virtualtable.ColumnData;
import org.eclipse.swt.widgets.Composite;

public class CustomEventsTable
extends TmfEventsTable {
    private final CustomTraceDefinition fDefinition;

    public CustomEventsTable(CustomTraceDefinition definition, Composite parent, int cacheSize) {
        super(parent, cacheSize, new ColumnData[0]);
        this.fDefinition = definition;
        this.createColumnHeaders();
    }

    protected void createColumnHeaders() {
        if (this.fDefinition == null) {
            return;
        }
        LinkedList<ColumnData> columnData = new LinkedList<ColumnData>();
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            ColumnData column = new ColumnData(outputColumn.name, 0, 16384);
            columnData.add(column);
        }
        this.setColumnHeaders(columnData.toArray(new ColumnData[0]));
    }

    public TmfEventField[] extractItemFields(ITmfEvent event) {
        if (event instanceof CustomEvent) {
            TmfEventField[] fields = ((CustomEvent)event).extractItemFields();
            return fields;
        }
        return new TmfEventField[0];
    }
}

