/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.LibraryContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackageContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackageElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourceContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourceElement;
import org.eclipse.dltk.ui.StandardModelElementContentProvider2;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class InstrumentationContentProvider
extends StandardModelElementContentProvider2 {
    private boolean fIsFlatLayout = false;
    private Object input;

    public InstrumentationContentProvider() {
        super(false, false);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof SelectionDialogInput) {
            SourceContainerElement sourceContainer;
            PackageContainerElement packageContainer;
            SelectionDialogInput input = (SelectionDialogInput)inputElement;
            Set<IScriptProject> projects = input.collectProjects();
            ArrayList<Object> result = new ArrayList<Object>();
            result.addAll(projects);
            LibraryContainerElement libContainer = new LibraryContainerElement(input);
            if (libContainer.getChildren().length != 0) {
                result.add(libContainer);
            }
            if ((packageContainer = new PackageContainerElement(input)).getChildren().length != 0) {
                result.add(packageContainer);
            }
            if ((sourceContainer = new SourceContainerElement(input)).getChildren().length != 0) {
                result.add(sourceContainer);
            }
            return result.toArray();
        }
        return NO_CHILDREN;
    }

    protected boolean isValidProjectFragment(IProjectFragment root) {
        return !root.isExternal();
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IScriptProject) {
            return null;
        }
        if (element instanceof IProjectFragment && LibraryContainerElement.isValid((IProjectFragment)element)) {
            return new LibraryContainerElement((SelectionDialogInput)this.input);
        }
        if (element instanceof PackageElement) {
            return new PackageContainerElement((SelectionDialogInput)this.input);
        }
        if (element instanceof SourceElement) {
            return new SourceContainerElement((SelectionDialogInput)this.input);
        }
        if (!this.fIsFlatLayout && element instanceof IScriptFolder) {
            return this.getHierarchicalPackageParent((IScriptFolder)element);
        }
        return super.internalGetParent(element);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IWorkbenchAdapter) {
            return ((IWorkbenchAdapter)element).getChildren(element);
        }
        return super.getChildren(element);
    }

    protected Object[] getProjectFragmentContent(IProjectFragment root) throws ModelException {
        if (this.fIsFlatLayout) {
            return super.getProjectFragmentContent(root);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren(root, null, result);
        if (this.fForeignResources && !this.isProjectProjectFragment(root)) {
            Object[] nonJavaResources = root.getForeignResources();
            int i = 0;
            while (i < nonJavaResources.length) {
                result.add(nonJavaResources[i]);
                ++i;
            }
        }
        return result.toArray();
    }

    protected Object[] getScriptFolderContent(IScriptFolder fragment) throws ModelException {
        if (this.fIsFlatLayout) {
            return super.getScriptFolderContent(fragment);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren((IProjectFragment)fragment.getParent(), fragment, result);
        Object[] nonPackages = super.getScriptFolderContent(fragment);
        if (result.isEmpty()) {
            return nonPackages;
        }
        int i = 0;
        while (i < nonPackages.length) {
            result.add(nonPackages[i]);
            ++i;
        }
        return result.toArray();
    }

    private void getHierarchicalPackageChildren(IProjectFragment parent, IScriptFolder fragment, Collection result) throws ModelException {
        IModelElement[] children = parent.getChildren();
        ArrayList<IModelElement> newElements = new ArrayList<IModelElement>();
        if (fragment == null || fragment.isRootFolder()) {
            int i = 0;
            while (i < children.length) {
                IScriptFolder scriptFolder;
                if (children[i] instanceof IScriptFolder && (scriptFolder = (IScriptFolder)children[i]).isRootFolder()) {
                    IModelElement[] members = scriptFolder.getChildren();
                    int j = 0;
                    while (j < members.length) {
                        newElements.add(members[j]);
                        ++j;
                    }
                } else {
                    newElements.add(children[i]);
                }
                ++i;
            }
            children = newElements.toArray(new IModelElement[newElements.size()]);
        }
        String prefix = fragment != null ? String.valueOf(fragment.getElementName()) + "/" : "";
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IScriptFolder) {
                IScriptFolder curr = (IScriptFolder)children[i];
                String name = curr.getElementName();
                if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(47, prefixLen) == -1) {
                    result.add(curr);
                }
            } else {
                result.add(children[i]);
            }
            ++i;
        }
    }

    public Object getHierarchicalPackageParent(IScriptFolder child) {
        String name = child.getElementName();
        IProjectFragment parent = (IProjectFragment)child.getParent();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IScriptFolder element = parent.getScriptFolder(realParentName);
            if (element.exists()) {
                return element;
            }
            IResource resource = element.getResource();
            if (resource != null) {
                return resource;
            }
        }
        if (parent.getResource() instanceof IProject) {
            return parent.getScriptProject();
        }
        return parent;
    }
}

