/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.MethodIndex;

public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    static final long serialVersionUID = 3590332973770104094L;
    private String name;
    public final int index;
    private Node argsNode;
    private Node iterNode;

    public FCallNode(ISourcePosition position, String name, Node argsNode) {
        this(position, name, argsNode, null);
    }

    public FCallNode(ISourcePosition position, String name, Node argsNode, Node iterNode) {
        super(position, 38);
        this.name = name.intern();
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.index = MethodIndex.getIndex(this.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = this.name.intern();
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public void setIterNode(Node iterNode) {
        this.iterNode = iterNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "FCallNode: " + this.getName();
    }
}

