/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.internal.core.packages.DefaultVariablesRegistry;
import org.eclipse.dltk.tcl.internal.core.packages.TclVariableResolver;
import org.eclipse.emf.common.util.EList;

public class TclSourcesUtils {
    public static Set<IPath> getBuildpath(IScriptProject project, Set<IScriptProject> projectVisitSet) {
        IBuildpathEntry[] resolvedBuildpath;
        if (projectVisitSet.contains(project)) {
            return Collections.emptySet();
        }
        projectVisitSet.add(project);
        try {
            resolvedBuildpath = project.getResolvedBuildpath(false);
        }
        catch (ModelException e1) {
            return Collections.emptySet();
        }
        HashSet<IPath> buildpath = new HashSet<IPath>();
        int i = 0;
        while (i < resolvedBuildpath.length) {
            IBuildpathEntry entry = resolvedBuildpath[i];
            if (entry.getEntryKind() == 1 && entry.isExternal()) {
                buildpath.add(entry.getPath());
            } else if (entry.getEntryKind() == 2) {
                IScriptProject scrPrj;
                IPath path = entry.getPath();
                IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
                if (prj != null && prj.isAccessible() && (scrPrj = DLTKCore.create((IProject)prj)) != null && scrPrj.exists()) {
                    buildpath.addAll(TclSourcesUtils.getBuildpath(scrPrj, projectVisitSet));
                }
            }
            ++i;
        }
        return buildpath;
    }

    public static Set<IPath> getPackages(IScriptProject project, IInterpreterInstall install) {
        HashSet<IPath> result = new HashSet<IPath>();
        HashSet<String> packages = new HashSet<String>();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project, packages, packages);
        List<TclPackageInfo> packageInfos = TclPackagesManager.getPackageInfos(install, packages, true);
        for (TclPackageInfo tclPackageInfo : packageInfos) {
            EList<String> sources = tclPackageInfo.getSources();
            for (String source : sources) {
                result.add((IPath)new Path(source));
            }
        }
        return result;
    }

    public static void fillSources(IInterpreterInstall install, IScriptProject scriptProject, Set<IPath> sources, Map<IPath, String> originalNames, Set<String> pseutoElements) {
        HashSet<IScriptProject> visitedProjects = new HashSet<IScriptProject>();
        Set<IPath> buildpath = TclSourcesUtils.getBuildpath(scriptProject, visitedProjects);
        Set<IPath> packageFiles = TclSourcesUtils.getPackages(scriptProject, install);
        TclVariableResolver variableResolver = new TclVariableResolver(new DefaultVariablesRegistry(scriptProject));
        List<TclModuleInfo> modules = TclPackagesManager.getProjectModules(scriptProject.getElementName());
        for (TclModuleInfo tclModuleInfo : modules) {
            EList<TclSourceEntry> sourced = tclModuleInfo.getSourced();
            EList<UserCorrection> corrections = tclModuleInfo.getSourceCorrections();
            HashMap<String, EList<String>> correctionMap = new HashMap<String, EList<String>>();
            for (UserCorrection userCorrection : corrections) {
                correctionMap.put(userCorrection.getOriginalValue(), userCorrection.getUserValue());
            }
            for (TclSourceEntry source : sourced) {
                ArrayList<String> values = null;
                if (correctionMap.containsKey(source.getValue())) {
                    values = (Collection)correctionMap.get(source.getValue());
                }
                if (values == null || values.isEmpty()) {
                    String resolved = variableResolver.resolve(source.getValue());
                    if (resolved == null || resolved.equals(source.getValue())) {
                        pseutoElements.add(source.getValue());
                        continue;
                    }
                    values = new ArrayList<String>();
                    values.add(resolved);
                }
                for (String value : values) {
                    IEnvironment environment;
                    IFileHandle handle;
                    Path path = new Path(value);
                    IPath pathParent = path.removeLastSegments(1);
                    if (buildpath.contains(pathParent) || packageFiles.contains(path)) continue;
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    if (file != null) {
                        boolean onBuildpath = false;
                        for (IScriptProject p : visitedProjects) {
                            if (!p.isOnBuildpath((IResource)file) || !DLTKContentTypeManager.isValidResourceForContentType((IDLTKLanguageToolkit)TclLanguageToolkit.getDefault(), (IResource)file)) continue;
                            onBuildpath = true;
                            break;
                        }
                        if (onBuildpath) continue;
                    }
                    if (originalNames != null) {
                        originalNames.put((IPath)path, source.getValue());
                    }
                    if (!(handle = (environment = EnvironmentManager.getEnvironment((IModelElement)scriptProject)).getFile((IPath)path)).exists()) continue;
                    sources.add((IPath)path);
                }
            }
        }
    }
}

