/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.internal.ui.navigator.ProjectFragmentContainer;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public class RefreshAction
extends SelectionDispatchAction {
    public RefreshAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.RefreshAction_label);
        this.setToolTipText(ActionMessages.RefreshAction_toolTip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this, "refresh_nav.png");
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return true;
        }
        for (Object element : selection) {
            if (element instanceof IWorkingSet) continue;
            if (element instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                if (resource == null) {
                    return false;
                }
                if (resource.getType() != 4 || ((IProject)resource).isOpen()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void performRefresh(IStructuredSelection selection, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor.beginTask(ActionMessages.RefreshAction_progressMessage, 2);
        WrappedWorkbenchRefreshAction workbenchAction = new WrappedWorkbenchRefreshAction((IShellProvider)this.getSite());
        workbenchAction.selectionChanged(selection);
        workbenchAction.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.refreshScriptElements(selection, new SubProgressMonitor(monitor, 1));
    }

    private void refreshScriptElements(IStructuredSelection selection, SubProgressMonitor monitor) throws CoreException {
        Object[] selectedElements = selection.toArray();
        ArrayList<Object> modelElements = new ArrayList<Object>();
        int i = 0;
        while (i < selectedElements.length) {
            Object curr = selectedElements[i];
            if (curr instanceof IProjectFragment) {
                modelElements.add((IProjectFragment)curr);
            } else if (curr instanceof ProjectFragmentContainer) {
                modelElements.addAll(Arrays.asList(((ProjectFragmentContainer)curr).getProjectFragments()));
            } else if (curr instanceof IWorkingSet) {
                IAdaptable[] members = ((IWorkingSet)curr).getElements();
                int k = 0;
                while (k < members.length) {
                    IModelElement adapted = (IModelElement)members[k].getAdapter(IModelElement.class);
                    if (adapted instanceof ProjectFragmentContainer) {
                        modelElements.add(adapted);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (!modelElements.isEmpty()) {
            ModelManager.getModelManager().getDeltaProcessor().checkExternalChanges(modelElements.toArray(new IModelElement[modelElements.size()]), (IProgressMonitor)monitor);
        }
    }

    @Override
    public void run(final IStructuredSelection selection) {
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RefreshAction.this.performRefresh(selection, monitor);
            }
        };
        new WorkbenchRunnableAdapter(operation).runAsUserJob(ActionMessages.RefreshAction_refresh_operation_label, null);
    }

    private static class WrappedWorkbenchRefreshAction
    extends org.eclipse.ui.actions.RefreshAction {
        public WrappedWorkbenchRefreshAction(IShellProvider provider) {
            super(provider);
        }

        protected List<? extends IResource> getSelectedResources() {
            List selectedResources = super.getSelectedResources();
            if (!this.getStructuredSelection().isEmpty() && selectedResources.size() == 1 && selectedResources.get(0) instanceof IWorkspaceRoot) {
                selectedResources = Collections.emptyList();
            }
            ArrayList<IResource> allResources = new ArrayList<IResource>(selectedResources);
            this.addWorkingSetResources(allResources);
            return allResources;
        }

        private void addWorkingSetResources(List<IResource> selectedResources) {
            Object[] elements = this.getStructuredSelection().toArray();
            int i = 0;
            while (i < elements.length) {
                Object curr = elements[i];
                if (curr instanceof IWorkingSet) {
                    IAdaptable[] members = ((IWorkingSet)curr).getElements();
                    int k = 0;
                    while (k < members.length) {
                        IResource adapted = (IResource)members[k].getAdapter(IResource.class);
                        if (adapted != null) {
                            selectedResources.add(adapted);
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }

        public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            try {
                IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
                this.createOperation(errorStatus).run(monitor);
                if (errorStatus[0].matches(4)) {
                    throw new CoreException(errorStatus[0]);
                }
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof CoreException) {
                    throw (CoreException)targetException;
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ui", ActionMessages.RefreshAction_error_workbenchaction_message, targetException));
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
    }
}

