/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.internal.corext.util.OpenTypeHistory;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.IInteractionElement;

public class TypeHistoryManager
extends AbstractContextListener {
    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: {
                for (IInteractionElement node : event.getContext().getInteresting()) {
                    this.updateTypeHistory(node, true);
                }
                break;
            }
            case DEACTIVATED: {
                this.clearTypeHistory();
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext()) break;
                this.clearTypeHistory();
                break;
            }
            case INTEREST_CHANGED: {
                for (IInteractionElement node : event.getElements()) {
                    this.updateTypeHistory(node, true);
                }
                break;
            }
            case ELEMENTS_DELETED: {
                for (IInteractionElement element : event.getElements()) {
                    this.updateTypeHistory(element, false);
                }
                break;
            }
        }
    }

    private void updateTypeHistory(IInteractionElement node, boolean add) {
        IModelElement element = DLTKCore.create((String)node.getHandleIdentifier());
        if (element instanceof IType) {
            IType type = (IType)element;
            try {
                if (type.exists() && !this.isAspectjType(type)) {
                    DLTKSearchTypeNameMatch typeNameMatch = new DLTKSearchTypeNameMatch(type, type.getFlags());
                    IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)element);
                    OpenTypeHistory history = OpenTypeHistory.getInstance((IDLTKUILanguageToolkit)toolkit);
                    if (add && !history.contains((TypeNameMatch)typeNameMatch)) {
                        history.accessed((TypeNameMatch)typeNameMatch);
                    } else {
                        history.remove((TypeNameMatch)typeNameMatch);
                    }
                }
            }
            catch (ModelException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Failed to update history for a type", (Throwable)e));
            }
        }
    }

    private boolean isAspectjType(IType type) {
        return type.getHandleIdentifier().indexOf(125) != -1;
    }

    public void clearTypeHistory() {
    }
}

