/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.navigator.ProjectFragmentContainer;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class BuildPathContainer
extends ProjectFragmentContainer {
    private IBuildpathEntry fClassPathEntry;
    private IBuildpathContainer fContainer;

    public BuildPathContainer(IScriptProject parent, IBuildpathEntry entry) {
        super(parent);
        this.fClassPathEntry = entry;
        try {
            this.fContainer = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)parent);
        }
        catch (ModelException modelException) {
            this.fContainer = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildPathContainer) {
            BuildPathContainer other = (BuildPathContainer)obj;
            if (this.getScriptProject().equals(other.getScriptProject()) && this.fClassPathEntry.equals(other.fClassPathEntry)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getScriptProject().hashCode() * 17 + this.fClassPathEntry.hashCode();
    }

    @Override
    public IProjectFragment[] getProjectFragments() {
        return this.getScriptProject().findProjectFragments(this.fClassPathEntry);
    }

    @Override
    public IAdaptable[] getChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        IProjectFragment[] roots = this.getProjectFragments();
        int i = 0;
        while (i < roots.length) {
            list.add(roots[i]);
            ++i;
        }
        if (this.fContainer != null) {
            IBuildpathEntry[] classpathEntries = this.fContainer.getBuildpathEntries();
            if (classpathEntries == null) {
                DLTKUIPlugin.log(new IllegalArgumentException("Invalid classpath container implementation: getClasspathEntries() returns null. " + this.fContainer.getPath()));
            } else {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int i2 = 0;
                while (i2 < classpathEntries.length) {
                    IResource resource;
                    IBuildpathEntry entry = classpathEntries[i2];
                    if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) instanceof IProject) {
                        list.add(new RequiredProjectWrapper(this, DLTKCore.create((IProject)((IProject)resource))));
                    }
                    ++i2;
                }
            }
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return DLTKPluginImages.DESC_OBJS_LIBRARY;
    }

    @Override
    public String getLabel() {
        if (this.fContainer != null) {
            return this.fContainer.getDescription();
        }
        IPath path = this.fClassPathEntry.getPath();
        String containerId = path.segment(0);
        BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)containerId);
        if (initializer != null) {
            String description = initializer.getDescription(path, this.getScriptProject());
            return Messages.format(ScriptMessages.BuildPathContainer_unbound_label, description);
        }
        return Messages.format(ScriptMessages.BuildPathContainer_unknown_label, path.toString());
    }

    public IBuildpathEntry getBuildpathEntry() {
        return this.fClassPathEntry;
    }

    static boolean contains(IScriptProject project, IBuildpathEntry entry, IProjectFragment root) {
        IProjectFragment[] roots = project.findProjectFragments(entry);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].equals(root)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class RequiredProjectWrapper
    implements IAdaptable,
    IWorkbenchAdapter {
        private final BuildPathContainer fParent;
        private final IScriptProject fProject;

        public RequiredProjectWrapper(BuildPathContainer parent, IScriptProject project) {
            this.fParent = parent;
            this.fProject = project;
        }

        public IScriptProject getProject() {
            return this.fProject;
        }

        public BuildPathContainer getParentClassPathContainer() {
            return this.fParent;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return (T)this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        }

        public String getLabel(Object o) {
            return this.fProject.getElementName();
        }

        public Object getParent(Object o) {
            return this.fParent;
        }
    }
}

