/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.BigNumericLiteral;
import org.eclipse.dltk.ast.expressions.BooleanLiteral;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.FloatNumericLiteral;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.expressions.NilLiteral;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ruby.ast.IRubyASTVisitor;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyCallArgument;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyConstantDeclaration;
import org.eclipse.dltk.ruby.ast.RubyHashExpression;
import org.eclipse.dltk.ruby.ast.RubyHashPairExpression;
import org.eclipse.dltk.ruby.ast.RubyRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubySymbolReference;
import org.eclipse.dltk.ruby.internal.parser.visitors.Messages;
import org.eclipse.dltk.ruby.internal.parser.visitors.RubyAttributeHandler;

public class RubySourceElementRequestor
extends SourceElementRequestVisitor
implements IRubyASTVisitor {
    private static final String VALUE = "value";
    private static final String INITIALIZE = "initialize";
    private List<TypeField> fNotAddedFields = new ArrayList<TypeField>();
    private Map<ASTNode, List<String>> fTypeVariables = new HashMap<ASTNode, List<String>>();

    private boolean canAddVariables(ASTNode type, String name) {
        if (this.fTypeVariables.containsKey(type)) {
            List<String> variables = this.fTypeVariables.get(type);
            if (variables.contains(name)) {
                return false;
            }
            variables.add(name);
            return true;
        }
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(name);
        this.fTypeVariables.put(type, variables);
        return true;
    }

    private void addVariableReference(ASTNode left, ASTNode right, boolean inClass, boolean inMethod) {
        if (left == null) {
            throw new IllegalArgumentException(Messages.RubySourceElementRequestor_addVariableExpressionCantBeNull);
        }
        if (left instanceof VariableReference) {
            VariableReference var = (VariableReference)left;
            if (!inMethod && this.canAddVariables((ASTNode)this.fNodes.peek(), var.getName())) {
                IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                info.modifiers = 128;
                info.name = var.getName();
                info.nameSourceEnd = var.sourceEnd() - 1;
                info.nameSourceStart = var.sourceStart();
                info.declarationStart = var.sourceStart();
                this.fRequestor.enterField(info);
                if (right != null) {
                    this.fRequestor.exitField(right.sourceEnd() - 1);
                } else {
                    this.fRequestor.exitField(var.sourceEnd() - 1);
                }
            }
        }
    }

    protected String makeLanguageDependentValue(ASTNode value) {
        String outValue = "";
        return outValue;
    }

    public RubySourceElementRequestor(ISourceElementRequestor requestor) {
        super((IElementRequestor)requestor);
    }

    protected void onEndVisitMethod(MethodDeclaration method) {
        if (DLTKCore.DEBUG) {
            System.out.println("==> Method: " + method.getName());
        }
        for (TypeField field : this.fNotAddedFields) {
            if (!this.canAddVariables(field.getASTNode(), field.getName())) continue;
            PositionInformation pos = field.getPosition();
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.modifiers = 128;
            info.name = field.getName();
            info.nameSourceEnd = pos.nameEnd - 1;
            info.nameSourceStart = pos.nameStart;
            info.declarationStart = pos.sourceStart;
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(pos.sourceEnd);
        }
        this.fNotAddedFields.clear();
    }

    private void reportTypeReferences(ASTNode node) {
        while (node != null) {
            String typeName;
            if (node instanceof RubyColonExpression) {
                typeName = ((RubyColonExpression)node).getName();
                this.fRequestor.acceptTypeReference(typeName, node.sourceStart());
                node = ((RubyColonExpression)node).getLeft();
                continue;
            }
            if (node instanceof ConstantReference) {
                typeName = ((ConstantReference)node).getName();
                this.fRequestor.acceptTypeReference(typeName, node.sourceStart());
                node = null;
                continue;
            }
            node = null;
        }
    }

    @Override
    public void visitTypeName(ASTNode node) {
    }

    public boolean visit(ASTNode expression) throws Exception {
        RubyAliasExpression alias;
        String oldValue;
        if (DLTKCore.DEBUG) {
            System.out.println("==> Expression: " + expression.toString());
        }
        if (expression instanceof RubyAssignment) {
            RubyAssignment assignment = (RubyAssignment)expression;
            ASTNode left = assignment.getLeft();
            ASTNode right = assignment.getRight();
            this.addVariableReference(left, right, this.fInClass, this.fInMethod);
        } else if (expression instanceof CallExpression) {
            int end;
            int start;
            List args;
            CallExpression callExpression = (CallExpression)expression;
            if (RubyAttributeHandler.isAttributeCreationCall(callExpression)) {
                RubyAttributeHandler info = new RubyAttributeHandler(callExpression);
                List<ASTNode> readers = info.getReaders();
                for (ASTNode n : readers) {
                    String attr = RubyAttributeHandler.getText(n);
                    IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
                    mi.name = attr;
                    mi.modifiers = 0x100000;
                    mi.nameSourceStart = n.sourceStart();
                    mi.nameSourceEnd = n.sourceEnd() - 1;
                    mi.declarationStart = n.sourceStart();
                    this.fRequestor.enterMethod(mi);
                    this.fRequestor.exitMethod(n.sourceEnd());
                }
                List<ASTNode> writers = info.getWriters();
                for (ASTNode n : writers) {
                    String attr = RubyAttributeHandler.getText(n);
                    IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
                    mi.parameterNames = new String[]{VALUE};
                    mi.name = String.valueOf(attr) + "=";
                    mi.modifiers = 0x100000;
                    mi.nameSourceStart = n.sourceStart();
                    mi.nameSourceEnd = n.sourceEnd() - 1;
                    mi.declarationStart = n.sourceStart();
                    this.fRequestor.enterMethod(mi);
                    this.fRequestor.exitMethod(n.sourceEnd());
                }
            } else if ("delegate".equals(callExpression.getName())) {
                for (RubyCallArgument argNode : callExpression.getArgs().getChilds()) {
                    if (!(argNode.getValue() instanceof RubyHashExpression)) continue;
                    for (RubyHashPairExpression hashNode : argNode.getValue().getChilds()) {
                        if (hashNode.getValue() instanceof RubySymbolReference) {
                            ((RubySymbolReference)hashNode.getValue()).getName();
                            continue;
                        }
                        if (!(hashNode.getValue() instanceof StringLiteral)) continue;
                        ((StringLiteral)hashNode.getValue()).getValue();
                    }
                }
                for (RubyCallArgument argNode : callExpression.getArgs().getChilds()) {
                    String dName = null;
                    if (argNode.getValue() instanceof RubySymbolReference) {
                        dName = ((RubySymbolReference)argNode.getValue()).getName();
                    } else if (argNode.getValue() instanceof StringLiteral) {
                        dName = ((StringLiteral)argNode.getValue()).getValue();
                    }
                    if (dName == null) continue;
                    IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
                    mi.name = dName;
                    mi.modifiers = 0x200000;
                    mi.nameSourceStart = argNode.sourceStart();
                    mi.nameSourceEnd = argNode.sourceEnd() - 1;
                    mi.declarationStart = argNode.sourceStart();
                    this.fRequestor.enterMethod(mi);
                    this.fRequestor.exitMethod(argNode.sourceEnd());
                }
            } else if ("require".equals(callExpression.getName()) && (args = callExpression.getArgs().getChilds()).size() == 1 && args.get(0) instanceof RubyCallArgument) {
                RubyCallArgument argument = (RubyCallArgument)((Object)args.get(0));
                IElementRequestor.ImportInfo importInfo = new IElementRequestor.ImportInfo();
                importInfo.sourceStart = callExpression.sourceStart();
                importInfo.sourceEnd = callExpression.sourceEnd();
                importInfo.containerName = "require";
                if (argument.getValue() instanceof StringLiteral) {
                    StringLiteral lit = (StringLiteral)argument.getValue();
                    importInfo.name = lit.getValue();
                }
                if (importInfo.name != null) {
                    this.fRequestor.acceptImport(importInfo);
                }
            }
            int argsCount = 0;
            CallArgumentsList args2 = callExpression.getArgs();
            if (args2 != null && args2.getChilds() != null) {
                argsCount = args2.getChilds().size();
            }
            if ((start = callExpression.sourceStart()) < 0) {
                start = 0;
            }
            if ((end = callExpression.sourceEnd()) < 0) {
                end = 1;
            }
            this.fRequestor.acceptMethodReference(callExpression.getName(), argsCount, start, end);
        } else if (expression instanceof Literal) {
            if (expression instanceof RubyRegexpExpression) {
                this.fRequestor.acceptTypeReference("Regexp", expression.sourceStart());
            } else if (expression instanceof StringLiteral) {
                this.fRequestor.acceptTypeReference("String", expression.sourceStart());
            } else if (expression instanceof BooleanLiteral) {
                BooleanLiteral boolLit = (BooleanLiteral)expression;
                if (boolLit.boolValue()) {
                    this.fRequestor.acceptTypeReference("TrueClass", expression.sourceStart());
                } else {
                    this.fRequestor.acceptTypeReference("FalseClass", expression.sourceStart());
                }
            } else if (expression instanceof NumericLiteral) {
                this.fRequestor.acceptTypeReference("Fixnum", expression.sourceStart());
            } else if (expression instanceof NilLiteral) {
                this.fRequestor.acceptTypeReference("NilClass", expression.sourceStart());
            } else if (expression instanceof FloatNumericLiteral) {
                this.fRequestor.acceptTypeReference("Float", expression.sourceStart());
            } else if (expression instanceof BigNumericLiteral) {
                this.fRequestor.acceptTypeReference("Bignum", expression.sourceStart());
            }
        } else if (expression instanceof Reference) {
            if (expression instanceof RubySymbolReference) {
                this.fRequestor.acceptTypeReference("Symbol", expression.sourceStart());
            } else if (expression instanceof VariableReference) {
                VariableReference variableReference = (VariableReference)expression;
                int pos = variableReference.sourceStart();
                if (pos < 0) {
                    pos = 0;
                }
                this.fRequestor.acceptFieldReference(variableReference.getName(), pos);
            } else if (expression instanceof ConstantReference) {
                this.reportTypeReferences(expression);
            }
        } else if (expression instanceof RubyColonExpression) {
            this.reportTypeReferences(expression);
        } else if (expression instanceof RubyConstantDeclaration) {
            RubyConstantDeclaration constant = (RubyConstantDeclaration)expression;
            SimpleReference constName = constant.getName();
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.modifiers = 2;
            info.name = constName.getName();
            info.nameSourceEnd = constName.sourceEnd() - 1;
            info.nameSourceStart = constName.sourceStart();
            info.declarationStart = constName.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(constName.sourceEnd() - 1);
        } else if (expression instanceof RubyAliasExpression && !(oldValue = (alias = (RubyAliasExpression)expression).getOldValue()).startsWith("$")) {
            String newValue = alias.getNewValue();
            IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
            mi.name = newValue;
            mi.modifiers = 0x200000;
            mi.nameSourceStart = alias.sourceStart();
            mi.nameSourceEnd = alias.sourceEnd() - 1;
            mi.declarationStart = alias.sourceStart();
            this.fRequestor.enterMethod(mi);
            this.fRequestor.exitMethod(alias.sourceEnd());
        }
        return true;
    }

    public boolean endvisit(ASTNode expression) throws Exception {
        return true;
    }

    public boolean visit(Expression expression) throws Exception {
        super.visit(expression);
        return this.visit((ASTNode)expression);
    }

    public boolean visit(Statement statement) throws Exception {
        super.visit(statement);
        return this.visit((ASTNode)statement);
    }

    protected void modifyMethodInfo(MethodDeclaration methodDeclaration, IElementRequestor.MethodInfo mi) {
        if (this.fInClass) {
            mi.isConstructor = methodDeclaration.getName().equals(INITIALIZE);
        }
    }

    private static class TypeField {
        private String fName;
        private String fInitValue;
        private PositionInformation fPos;
        private ASTNode fExpression;
        private ASTNode fToNode;

        public TypeField(String name, String initValue, PositionInformation pos, ASTNode expression, ASTNode toNode) {
            this.fName = name;
            this.fInitValue = initValue;
            this.fPos = pos;
            this.fExpression = expression;
            this.fToNode = toNode;
        }

        public String getName() {
            return this.fName;
        }

        public String getInitValue() {
            return this.fInitValue;
        }

        public PositionInformation getPosition() {
            return this.fPos;
        }

        public ASTNode getExpression() {
            return this.fExpression;
        }

        public ASTNode getASTNode() {
            return this.fToNode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeField) {
                TypeField typeFileld = (TypeField)obj;
                return typeFileld.fName.equals(this.fName) && typeFileld.fToNode.equals(this.fToNode);
            }
            return false;
        }

        public String toString() {
            return this.fName;
        }
    }
}

