/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDropAdapter;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;

public class FileTransferDropAdapter
extends DLTKViewerDropAdapter
implements TransferDropTargetListener {
    public FileTransferDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
        this.setScrollEnabled(true);
        this.setExpandEnabled(true);
        this.setFeedbackEnabled(false);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IModelElement || target instanceof IResource;
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return this.determineOperation(target, operation, transferType, 7) != 0;
    }

    @Override
    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        IModelElement element;
        IContainer container;
        boolean isScriptFolder = target instanceof IScriptFolder;
        boolean isScriptProject = target instanceof IScriptProject;
        boolean isProjectFragment = target instanceof IProjectFragment;
        boolean isContainer = target instanceof IContainer;
        if (!(isScriptFolder || isScriptProject || isProjectFragment || isContainer)) {
            return 0;
        }
        if (isContainer ? (container = (IContainer)target).isAccessible() && !Resources.isReadOnly((IResource)container) : !(element = (IModelElement)target).isReadOnly()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean performDrop(final Object data) {
        IContainer target;
        block5: {
            block4: {
                try {
                    int operation = this.getCurrentOperation();
                    if (data != null && data instanceof String[] && operation == 1) break block4;
                    return false;
                }
                catch (ModelException e) {
                    String title = ScriptMessages.DropAdapter_errorTitle;
                    String message = ScriptMessages.DropAdapter_errorMessage;
                    ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
                    return true;
                }
            }
            target = this.getActualTarget(this.getCurrentTarget());
            if (target != null) break block5;
            return false;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                FileTransferDropAdapter.this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(FileTransferDropAdapter.this.getShell()).copyFiles((String[])data, target);
            }
        });
        return false;
    }

    private IContainer getActualTarget(Object dropTarget) throws ModelException {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof IModelElement) {
            return this.getActualTarget(((IModelElement)dropTarget).getCorrespondingResource());
        }
        return null;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

