/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.templates;

import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionString;
import org.eclipse.dltk.javascript.internal.core.codeassist.JavaScriptCompletionUtil;
import org.eclipse.dltk.javascript.internal.ui.templates.JavaScriptTemplateAccess;
import org.eclipse.dltk.javascript.internal.ui.templates.JavaScriptTemplateProposal;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.templates.ScriptTemplateCompletionProcessor;
import org.eclipse.dltk.ui.text.DocumentUtils;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;

public class JavaScriptTemplateCompletionProcessor
extends ScriptTemplateCompletionProcessor {
    private static final char[] IGNORE = new char[]{'.'};

    public JavaScriptTemplateCompletionProcessor(ScriptContentAssistInvocationContext context) {
        super(context);
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        int i = offset;
        IDocument document = viewer.getDocument();
        if (i > document.getLength()) {
            return "";
        }
        return CompletionString.parse((String)document.get().substring(0, offset), (boolean)false, (boolean)true);
    }

    protected String getContextTypeId() {
        return "javascriptUniversalTemplateContextType";
    }

    protected char[] getIgnore() {
        return IGNORE;
    }

    protected ScriptTemplateAccess getTemplateAccess() {
        return JavaScriptTemplateAccess.getInstance();
    }

    protected boolean isValidPrefix(String prefix) {
        return true;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new JavaScriptTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        if (this.isValidLocation(viewer, region)) {
            JavaScriptCompletionUtil.ExpressionType type = JavaScriptCompletionUtil.evaluateExpressionType((ISourceModule)this.getContext().getSourceModule(), (CharSequence)DocumentUtils.asCharSequence((IDocument)viewer.getDocument()), (int)(region.getOffset() + region.getLength()));
            if (type == JavaScriptCompletionUtil.ExpressionType.OBJECT_INITIALIZER) {
                return null;
            }
            if (type == JavaScriptCompletionUtil.ExpressionType.PROPERTY_INITIALIZER_VALUE) {
                return this.getTemplateAccess().getContextTypeRegistry().getContextType("javascriptExpressionTemplateContextType");
            }
        }
        return super.getContextType(viewer, region);
    }
}

