/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierExtension2;
import org.eclipse.dltk.compiler.problem.IProblemSeverityTranslator;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.PreferencesLookupDelegate;

public class DefaultProblemSeverityTranslator
extends PreferencesLookupDelegate
implements IProblemSeverityTranslator {
    private Map<IProblemIdentifier, ProblemSeverity> cache = new HashMap<IProblemIdentifier, ProblemSeverity>();

    public DefaultProblemSeverityTranslator(IScriptProject project) {
        super(project);
    }

    @Override
    public ProblemSeverity getSeverity(IProblemIdentifier problemId, ProblemSeverity defaultSeverity) {
        ProblemSeverity cached;
        IProblemIdentifier prime;
        if (problemId instanceof IProblemIdentifierExtension2 && (prime = ((IProblemIdentifierExtension2)((Object)problemId)).getPrimeIdentifier()) != null) {
            problemId = prime;
        }
        if ((cached = this.cache.get(problemId)) != null) {
            if (cached != ProblemSeverity.DEFAULT) {
                return cached;
            }
        } else {
            ProblemSeverity evaluated = this.evaluate(problemId);
            if (evaluated != null && evaluated != ProblemSeverity.DEFAULT) {
                this.cache.put(problemId, evaluated);
                return evaluated;
            }
            this.cache.put(problemId, ProblemSeverity.DEFAULT);
        }
        return IDENTITY.getSeverity(problemId, defaultSeverity);
    }

    private ProblemSeverity evaluate(IProblemIdentifier problemId) {
        String value = this.getString(problemId.contributor(), DefaultProblemIdentifier.encode(problemId));
        if (value != null && value.length() != 0) {
            try {
                return ProblemSeverity.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }
}

