/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.dltk.internal.javascript.core.manipulation.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.structure.BodyUpdater;
import org.eclipse.dltk.internal.javascript.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.DomFactory;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.rewrite.ASTConverter;
import org.eclipse.dltk.javascript.core.dom.rewrite.NodeFinder;
import org.eclipse.dltk.javascript.core.dom.rewrite.RefactoringUtils;
import org.eclipse.dltk.javascript.core.refactoring.descriptors.ChangeMethodSignatureDescriptor;
import org.eclipse.dltk.javascript.core.refactoring.descriptors.IntroduceParameterDescriptor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class IntroduceParameterRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_ARGUMENT = "argument";
    private ISourceModule fSourceCU;
    private Source root;
    private String source;
    private int fSelectionStart;
    private int fSelectionLength;
    private IMethod fMethod;
    private Refactoring fChangeSignatureRefactoring;
    private ChangeSignatureProcessor fChangeSignatureProcessor;
    private ParameterInfo fParameter;
    private Expression fSelectedExpression;

    public IntroduceParameterRefactoring(ISourceModule unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSourceCU = unit;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 7);
            if (!this.fSourceCU.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_syntax_error);
                return refactoringStatus;
            }
            this.root = (Source)ASTConverter.convert((ASTNode)JavaScriptParserUtil.parse((ISourceModule)this.fSourceCU));
            this.source = this.fSourceCU.getSource();
            this.initializeSelectedExpression();
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkSelection());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            this.fChangeSignatureProcessor = new ChangeSignatureProcessor(this.fMethod);
            this.fChangeSignatureRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)this.fChangeSignatureProcessor);
            this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
            result.merge(this.fChangeSignatureProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.addParameterInfo();
            this.fChangeSignatureProcessor.setBodyUpdater(new BodyUpdater(){

                @Override
                public void updateBody(FunctionExpression methodDeclaration) {
                    IntroduceParameterRefactoring.this.replaceSelectedExpression(methodDeclaration);
                }
            });
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void addParameterInfo() throws ModelException {
        String defaultValue = this.fSourceCU.getBuffer().getText(this.fSelectedExpression.getBegin(), this.fSelectedExpression.getEnd() - this.fSelectedExpression.getBegin());
        this.fParameter = ParameterInfo.createInfoForAddedParameter("", "", defaultValue);
        this.fChangeSignatureProcessor.getParameterInfos().add(this.fParameter);
    }

    private void replaceSelectedExpression(Node root) {
        Expression expression = (Expression)NodeFinder.findNode(root, this.fSelectedExpression.getBegin(), this.fSelectedExpression.getEnd());
        VariableReference result = DomFactory.eINSTANCE.createVariableReference();
        Identifier id = DomFactory.eINSTANCE.createIdentifier();
        id.setName(this.fParameter.getNewName());
        result.setVariable(id);
        EReference ref = expression.eContainmentFeature();
        if (ref.isMany()) {
            EList exprList = (EList)expression.eContainer().eGet((EStructuralFeature)ref);
            exprList.set(exprList.lastIndexOf((Object)expression), (Object)result);
        } else {
            expression.eContainer().eSet((EStructuralFeature)ref, (Object)result);
        }
    }

    private void initializeSelectedExpression() {
        Node selected = NodeFinder.findNode(this.root, this.fSelectionStart, this.fSelectionStart + this.fSelectionLength);
        if (!(selected instanceof Expression)) {
            return;
        }
        int i = this.fSelectionStart;
        while (i < selected.getBegin()) {
            if (!Character.isWhitespace(this.source.charAt(i))) {
                return;
            }
            ++i;
        }
        i = selected.getEnd();
        while (i < this.fSelectionStart + this.fSelectionLength) {
            if (!Character.isWhitespace(this.source.charAt(i))) {
                return;
            }
            ++i;
        }
        this.fSelectedExpression = (Expression)selected;
    }

    private RefactoringStatus createFatalError(String message) {
        SourceRange range = new SourceRange(this.fSelectionStart, this.fSelectionLength);
        return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)ScriptStatusContext.create((ISourceModule)this.fSourceCU, (ISourceRange)range));
    }

    private RefactoringStatus checkSelection() throws ModelException {
        if (this.fSelectedExpression == null) {
            return this.createFatalError(RefactoringCoreMessages.IntroduceParameterRefactoring_select);
        }
        Node node = NodeFinder.findEnclosingNode(this.fSelectedExpression);
        if (!(node instanceof FunctionExpression)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
        }
        IModelElement element = this.fSourceCU.getElementAt(this.fSelectionStart);
        if (element == null || !(element instanceof IMethod)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
        }
        this.fMethod = (IMethod)element;
        return this.checkExpression();
    }

    private RefactoringStatus checkExpression() {
        Expression selectedExpression = this.fSelectedExpression;
        if (selectedExpression instanceof BinaryExpression && selectedExpression.eContainer() instanceof Expression && RefactoringUtils.isAssignment(((BinaryExpression)selectedExpression).getOperation())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
        }
        return null;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.fChangeSignatureProcessor.getParameterInfos();
    }

    public ParameterInfo getAddedParameterInfo() {
        return this.fParameter;
    }

    public String getMethodSignaturePreview() throws ModelException {
        return this.fChangeSignatureProcessor.getNewMethodSignature();
    }

    public RefactoringStatus validateInput() {
        return this.fChangeSignatureProcessor.checkSignature();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            RefactoringStatus refactoringStatus = this.fChangeSignatureRefactoring.checkFinalConditions(pm);
            return refactoringStatus;
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            Change[] changes = this.fChangeSignatureProcessor.getAllChanges();
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((RefactoringDescriptor)this.getRefactoringDescriptor(), RefactoringCoreMessages.IntroduceParameterRefactoring_name, changes);
            return dynamicValidationRefactoringChange;
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
            pm.done();
        }
    }

    private IntroduceParameterDescriptor getRefactoringDescriptor() {
        ChangeMethodSignatureDescriptor extended = (ChangeMethodSignatureDescriptor)this.fChangeSignatureProcessor.createDescriptor();
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put(ATTRIBUTE_ARGUMENT, this.fParameter.getNewName());
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        this.fChangeSignatureProcessor.getMethodName();
        try {
            this.fChangeSignatureProcessor.getOldMethodSignature();
        }
        catch (ModelException exception) {
            JavaScriptPlugin.error((Throwable)exception);
        }
        String description = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description_short, this.fChangeSignatureProcessor.getMethod().getElementName());
        return new IntroduceParameterDescriptor(extended.getProject(), description, "", arguments, extended.getFlags());
    }
}

