/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.Arrays;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserExtension;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.ITclCommandDetector;
import org.eclipse.dltk.tcl.core.ITclCommandDetectorExtension;
import org.eclipse.dltk.tcl.core.ITclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ITclSourceParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.internal.parser.ext.CommandManager;
import org.eclipse.dltk.tcl.internal.parser.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parser.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parser.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parser.raw.TclScript;
import org.eclipse.dltk.utils.TextUtils;

public class TclSourceParser
extends AbstractSourceParser
implements ITclSourceParser,
ITclParser,
ISourceParserExtension {
    private IProblemReporter problemReporter;
    protected ISourceLineTracker codeModel;
    protected String content;
    private String fileName;
    private int startPos = 0;
    boolean useProcessors = true;
    private int flags;
    private boolean useDetectors = true;
    private ModuleDeclaration moduleDeclaration;
    private ITclCommandProcessor localProcessor = new ITclCommandProcessor(){

        public ASTNode process(TclStatement st, ITclParser parser, ASTNode parent) {
            if (parent != null) {
                TclParseUtil.addToDeclaration(parent, (ASTNode)st);
                TclSourceParser.this.convertExecuteToBlocks(st);
            }
            return st;
        }

        public void setCurrentASTTree(ModuleDeclaration module) {
        }

        public void setDetectedParameter(Object parameter) {
        }
    };
    private ITclCommandDetector[] detectors;

    public ModuleDeclaration parse(IModuleSource input, IProblemReporter reporter) {
        this.initDetectors();
        this.problemReporter = reporter;
        this.content = input.getSourceContents();
        this.codeModel = TextUtils.createLineTracker((String)this.content);
        this.fileName = input.getFileName();
        this.moduleDeclaration = new ModuleDeclaration(this.content.length());
        this.parse(this.content, 0, (ASTNode)this.moduleDeclaration);
        return this.moduleDeclaration;
    }

    private void initDetectors() {
        if (this.detectors == null) {
            this.detectors = CommandManager.getInstance().getDetectors();
        }
    }

    private void convertExecuteToBlocks(TclStatement st) {
        ASTNode[] nodes = st.getExpressions().toArray(new ASTNode[st.getCount()]);
        int i = 0;
        while (i < nodes.length) {
            TclExecuteExpression tclExecuteExpression;
            String expression;
            if (nodes[i] instanceof TclExecuteExpression && (expression = (tclExecuteExpression = (TclExecuteExpression)nodes[i]).getExpression()).length() > 2) {
                expression = expression.substring(1, expression.length() - 1);
                TclAdvancedExecuteExpression newExpr = new TclAdvancedExecuteExpression(nodes[i].sourceStart(), nodes[i].sourceEnd());
                nodes[i] = newExpr;
                st.setExpressions(Arrays.asList(nodes));
                this.parse(expression, nodes[i].sourceStart() + 1 - this.getStartPos(), (ASTNode)newExpr);
            }
            ++i;
        }
        st.setExpressions(Arrays.asList(nodes));
    }

    public void parse(String content, int offset, ASTNode decl) {
        this.initDetectors();
        TclScript script = null;
        try {
            script = SimpleTclParser.staticParse((String)content);
        }
        catch (TclParseException e) {
            if (DLTKCore.DEBUG_PARSER) {
                e.printStackTrace();
            }
            return;
        }
        if (script == null) {
            return;
        }
        List commands = script.getCommands();
        for (TclCommand command : commands) {
            ITclCommandProcessor processor;
            TclStatement st = TclParseUtil.convertToAST(command, this.getFileName(), offset, this.content, this.startPos);
            if (st == null || (processor = this.locateProcessor(st, content, offset, decl)) == null) continue;
            try {
                ASTNode nde = processor.process(st, this, decl);
                if (nde == null) {
                    nde = this.localProcessor.process(st, this, decl);
                }
                if (nde == null || !this.useDetectors) continue;
                int i = 0;
                while (i < this.detectors.length) {
                    if (this.detectors[i] != null) {
                        this.detectors[i].processASTNode(nde);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                TclPlugin.error(e);
            }
        }
    }

    private ITclCommandProcessor locateProcessor(TclStatement command, String content, int offset, ASTNode decl) {
        if (!this.useProcessors) {
            return this.localProcessor;
        }
        if (command != null && command.getCount() > 0) {
            ITclCommandProcessor processor;
            Expression expr = command.getAt(0);
            if (!(expr instanceof SimpleReference)) {
                return this.localProcessor;
            }
            String name = ((SimpleReference)expr).getName();
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            if ((processor = CommandManager.getInstance().getProcessor(name)) == null && this.useDetectors) {
                int i = 0;
                while (i < this.detectors.length) {
                    if (this.detectors[i] != null) {
                        ITclCommandDetector.CommandInfo commandName;
                        if (this.detectors[i] instanceof ITclCommandDetectorExtension) {
                            ((ITclCommandDetectorExtension)((Object)this.detectors[i])).setBuildRuntimeModelFlag(this.isBuildingRuntimeModel());
                        }
                        if ((commandName = this.detectors[i].detectCommand(command, this.moduleDeclaration, decl)) != null) {
                            processor = CommandManager.getInstance().getProcessor(commandName.commandName);
                            if (processor == null) break;
                            processor.setDetectedParameter(commandName.parameter);
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (processor != null) {
                processor.setCurrentASTTree(this.moduleDeclaration);
                return processor;
            }
        }
        return this.localProcessor;
    }

    public ISourceLineTracker getCodeModel() {
        return this.codeModel;
    }

    public String getContent() {
        return this.content;
    }

    public String substring(int start, int end) {
        if (start > end) {
            return "";
        }
        try {
            return this.content.substring(start - this.startPos, end - this.startPos);
        }
        catch (IndexOutOfBoundsException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return "####error####";
        }
    }

    public IProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setOffset(int offset) {
        this.startPos = offset;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setProcessorsState(boolean state) {
        this.useProcessors = state;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    private boolean isBuildingRuntimeModel() {
        return false;
    }

    public void setUseDetectors(boolean b) {
        this.useDetectors = false;
    }

    public void setProblemReporter(IProblemReporter problemReporter2) {
        this.problemReporter = problemReporter2;
    }

    public void setModuleDeclaration(ModuleDeclaration moduleDeclaration) {
        this.moduleDeclaration = moduleDeclaration;
    }

    public void setContent(String content2) {
        this.content = content2;
    }
}

