/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.rewrite;

import java.util.ArrayList;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.emf.common.util.TreeIterator;

public class NodeFinder {
    public static Node findNode(Node node, int left, int right) {
        TreeIterator it = node.eAllContents();
        Node before = null;
        Node after = null;
        while (it.hasNext()) {
            Node cur = (Node)it.next();
            if (cur.getEnd() <= left) {
                if (before == null || cur.getEnd() >= before.getEnd() && cur.getBegin() > before.getBegin()) {
                    before = cur;
                } else {
                    it.prune();
                }
            }
            if (cur.getBegin() >= right) {
                if (after == null || cur.getBegin() <= after.getBegin() && cur.getEnd() < after.getEnd()) {
                    after = cur;
                } else {
                    it.prune();
                }
            }
            if (left <= cur.getBegin() && cur.getEnd() <= right) {
                return cur;
            }
            if (cur.getBegin() > left || right > cur.getEnd()) continue;
            switch (cur.eClass().getClassifierID()) {
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return cur;
                }
            }
        }
        return after == null ? (before == null ? null : before) : after;
    }

    public static Node[] findNodes(Source cuNode, Iterable<SearchMatch> searchResults) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (SearchMatch match : searchResults) {
            Node node = NodeFinder.findNode(cuNode, match);
            if (node == null) continue;
            result.add(node);
        }
        return result.toArray(new Node[result.size()]);
    }

    public static Node findNode(Source cuNode, SearchMatch searchResult) {
        Node selectedNode = NodeFinder.findNode(cuNode, searchResult.getOffset(), searchResult.getOffset() + searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        return selectedNode;
    }

    public static Node findNode(Source cuNode, ISourceRange sourceRange) {
        Node selectedNode = NodeFinder.findNode(cuNode, sourceRange.getOffset(), sourceRange.getOffset() + sourceRange.getLength());
        if (selectedNode == null) {
            return null;
        }
        return selectedNode;
    }

    public static Node findEnclosingNode(Node node) {
        while ((node = (Node)node.eContainer()) != null) {
            switch (node.eClass().getClassifierID()) {
                case 20: 
                case 21: 
                case 56: 
                case 58: {
                    return node;
                }
            }
        }
        return null;
    }
}

