/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptLanguageProvider;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.utils.AdaptUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class BuildPathsPropertyPage
extends PropertyPage
implements IStatusChangeListener,
IScriptLanguageProvider {
    public static final String PROP_ID = "org.eclipse.dltk.ui.propertyPages.BuildPathsPropertyPage";
    private static final String PAGE_SETTINGS = "BuildPathsPropertyPage";
    protected static final String INDEX = "pageIndex";
    public static final Object DATA_ADD_ENTRY = "add_buildpath_entry";
    public static final Object DATA_REVEAL_ENTRY = "select_buildpath_entry";
    public static final Object DATA_REVEAL_ATTRIBUTE_KEY = "select_buildpath_attribute_key";
    public static final Object DATA_BLOCK = "block_until_buildpath_applied";
    private BuildpathsBlock fBuildPathsBlock;
    private boolean fBlockOnApply = false;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IProject project = this.getProject();
        Control result = project == null || !this.isValidProject(project) ? this.createWithoutScript(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWith(parent, project));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected IDialogSettings getSettings() {
        IDialogSettings javaSettings = DLTKUIPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = javaSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = javaSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 3);
        }
        return pageSettings;
    }

    public void setVisible(boolean visible) {
        if (this.fBuildPathsBlock != null) {
            if (!visible) {
                if (this.fBuildPathsBlock.hasChangesInDialog()) {
                    String title = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_title;
                    String message = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_message;
                    String[] buttonLabels = new String[]{PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_save, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_discard, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_ignore};
                    MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
                    int res = dialog.open();
                    if (res == 0) {
                        this.performOk();
                    } else if (res == 1) {
                        this.fBuildPathsBlock.init(DLTKCore.create((IProject)this.getProject()), null);
                    }
                }
            } else if (!this.fBuildPathsBlock.hasChangesInDialog() && this.fBuildPathsBlock.hasChangesInBuildpathFile()) {
                this.fBuildPathsBlock.init(DLTKCore.create((IProject)this.getProject()), null);
            }
        }
        super.setVisible(visible);
    }

    private Control createWith(Composite parent, IProject project) {
        IWorkbenchPreferenceContainer pageContainer = null;
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            pageContainer = (IWorkbenchPreferenceContainer)container;
        }
        this.fBuildPathsBlock = this.createBuildPathBlock(pageContainer);
        this.fBuildPathsBlock.init(DLTKCore.create((IProject)project), null);
        return this.fBuildPathsBlock.createControl(parent);
    }

    protected BuildpathsBlock createBuildPathBlock(IWorkbenchPreferenceContainer pageContainer) {
        return new BuildpathsBlock(this, this.getSettings().getInt(INDEX), false, pageContainer);
    }

    private Control createWithoutScript(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_no_script_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_closed_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    protected IProject getProject() {
        IAdaptable adaptable = this.getElement();
        IProject project = (IProject)AdaptUtils.getAdapter((Object)adaptable, IProject.class);
        if (project != null) {
            return project;
        }
        IModelElement elem = (IModelElement)AdaptUtils.getAdapter((Object)adaptable, IModelElement.class);
        if (elem instanceof IScriptProject) {
            return ((IScriptProject)elem).getProject();
        }
        return null;
    }

    protected boolean isValidProject(IProject proj) {
        return DLTKLanguageManager.hasScriptNature((IProject)proj);
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            this.getSettings().put(INDEX, this.fBuildPathsBlock.getPageIndex());
            if (this.fBuildPathsBlock.hasChangesInDialog()) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                        BuildPathsPropertyPage.this.fBuildPathsBlock.configureScriptProject(monitor);
                    }
                };
                WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
                if (this.fBlockOnApply) {
                    try {
                        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, this.getShell(), PreferencesMessages.BuildPathsPropertyPage_error_title, PreferencesMessages.BuildPathsPropertyPage_error_message);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                } else {
                    op.runAsUserJob(PreferencesMessages.BuildPathsPropertyPage_job_title, null);
                }
            }
        }
        return true;
    }

    @Override
    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Object entryToAdd;
            Map map = (Map)data;
            Object selectedLibrary = map.get(DATA_REVEAL_ENTRY);
            if (selectedLibrary instanceof IBuildpathEntry) {
                String attributeKey;
                IBuildpathEntry entry = (IBuildpathEntry)selectedLibrary;
                Object attr = map.get(DATA_REVEAL_ATTRIBUTE_KEY);
                String string = attributeKey = attr instanceof String ? (String)attr : null;
                if (this.fBuildPathsBlock != null) {
                    this.fBuildPathsBlock.setElementToReveal(entry, attributeKey);
                }
            }
            if ((entryToAdd = map.get(DATA_ADD_ENTRY)) instanceof IBuildpathEntry && this.fBuildPathsBlock != null) {
                this.fBuildPathsBlock.addElement((IBuildpathEntry)entryToAdd);
            }
            this.fBlockOnApply = Boolean.TRUE.equals(map.get(DATA_BLOCK));
        }
    }
}

