/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;

class RFunctionType
extends RType
implements IRFunctionType {
    private final ITypeSystem typeSystem;
    private final List<IRParameter> parameters;
    private final IRType returnType;

    public RFunctionType(ITypeSystem typeSystem, List<IRParameter> parameters, IRType returnType) {
        this.typeSystem = typeSystem;
        this.parameters = parameters;
        this.returnType = returnType;
    }

    @Override
    public ITypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public String toString(Set<RType> processed) {
        if (!processed.add(this)) {
            return "function(_self)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("function");
        sb.append('(');
        int index = 0;
        for (IRParameter parameter : this.parameters) {
            if (++index != 1) {
                sb.append(", ");
            }
            if (parameter.getKind() == ParameterKind.VARARGS) {
                sb.append("...");
            }
            if (parameter.getType() instanceof RType) {
                sb.append(((RType)parameter.getType()).toString(processed));
            } else {
                sb.append(parameter.getType());
            }
            if (parameter.getKind() != ParameterKind.OPTIONAL) continue;
            sb.append("=");
        }
        sb.append(')');
        if (this.returnType != null) {
            sb.append(':');
            if (this.returnType instanceof RType) {
                sb.append(((RType)this.returnType).toString(processed));
            } else {
                sb.append(this.returnType);
            }
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.toString(new HashSet<RType>());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        block8: {
            block9: {
                if (super.isAssignableFrom(type).ok()) {
                    return TypeCompatibility.TRUE;
                }
                if (!(type instanceof RFunctionType)) break block8;
                funcType = (RFunctionType)type;
                v0 = returnType = this.getReturnType() == null || this.getReturnType() instanceof IRRecordType != false ? TypeCompatibility.TRUE : TypeCompatibility.FALSE;
                if (returnType == TypeCompatibility.FALSE && funcType.getReturnType() != null && this.getReturnType() != null) {
                    returnType = this.getReturnType().isAssignableFrom(funcType.getReturnType());
                }
                paramsType = TypeCompatibility.TRUE;
                if (returnType != TypeCompatibility.TRUE) break block9;
                v1 = paramsType = !(funcType.getParameters() != null && funcType.getParameters().size() != 0 || this.getParameters() != null && this.getParameters().size() != 0) ? TypeCompatibility.TRUE : TypeCompatibility.FALSE;
                if (funcType.getParameters() == null || funcType.getParameters().size() <= 0 || this.getParameters() == null || this.getParameters().size() <= 0) break block9;
                paramsType = TypeCompatibility.TRUE;
                i = 0;
                while (i < this.getParameters().size()) {
                    block10: {
                        parameter = this.getParameters().get(i);
                        if (parameter.getType() == null) break block10;
                        if (i >= funcType.getParameters().size()) ** GOTO lbl26
                        funcParam = funcType.getParameters().get(i);
                        if (funcParam.getType() != null) {
                            if (funcParam.getType().isAssignableFrom(parameter.getType()) == TypeCompatibility.FALSE) {
                                paramsType = TypeCompatibility.FALSE;
                                break;
                            }
                        } else {
                            paramsType = TypeCompatibility.FALSE;
                            break;
lbl26:
                            // 1 sources

                            if (!parameter.isOptional()) {
                                paramsType = TypeCompatibility.FALSE;
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
            return returnType == TypeCompatibility.TRUE && paramsType == TypeCompatibility.TRUE ? TypeCompatibility.TRUE : TypeCompatibility.FALSE;
        }
        if (type instanceof IRSimpleType) {
            return TypeCompatibility.valueOf(Types.FUNCTION == ((IRSimpleType)type).getTarget());
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public IRType getReturnType() {
        return this.returnType;
    }

    @Override
    public List<IRParameter> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RFunctionType other = (RFunctionType)obj;
        if (!this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }
}

