/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.actions.ActionMessages;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.debug.ui.breakpoints.IScriptBreakpointLineValidator;
import org.eclipse.dltk.debug.ui.breakpoints.Messages;
import org.eclipse.dltk.debug.ui.breakpoints.ScriptBreakpointLineValidatorFactory;
import org.eclipse.dltk.debug.ui.breakpoints.ScriptToggleBreakpointAdapter;
import org.eclipse.dltk.internal.debug.core.model.ScriptWatchpoint;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.tcl.internal.debug.ui.TclAddWatchpointDialog;
import org.eclipse.dltk.tcl.internal.debug.ui.actions.IToggleSpawnpointsTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TclToggleBreakpointAdapter
extends ScriptToggleBreakpointAdapter
implements IToggleSpawnpointsTarget {
    private static final IScriptBreakpointLineValidator validator = ScriptBreakpointLineValidatorFactory.createNonEmptyNoCommentValidator((String)"#");

    protected String getDebugModelId() {
        return "org.eclipse.dltk.debug.tclModel";
    }

    protected IScriptBreakpointLineValidator getValidator() {
        return validator;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.isFields(ss);
        }
        return selection instanceof ITextSelection;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection finalSelection) throws CoreException {
        ITextEditor textEditor;
        ISelection newSelection;
        List fields;
        this.report(null, part);
        ISelection selection = finalSelection;
        int lineNumber = -1;
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getDebugModelId());
        if (selection instanceof ITextSelection && part instanceof ITextEditor) {
            lineNumber = ((ITextSelection)selection).getStartLine() + 1;
            resource = BreakpointUtils.getBreakpointResource((ITextEditor)((ITextEditor)part));
        }
        if ((fields = selection instanceof IStructuredSelection ? this.getFields((IStructuredSelection)selection) : ((newSelection = this.translateToMembers(part, selection)) instanceof IStructuredSelection ? this.getFields((IStructuredSelection)newSelection) : Collections.EMPTY_LIST)).isEmpty() && selection instanceof ITextSelection && (textEditor = this.getTextEditor(part)) != null) {
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider != null) {
                IDocument document = documentProvider.getDocument((Object)editorInput);
                IRegion reg = ScriptWordFinder.findWord((IDocument)document, (int)((ITextSelection)selection).getOffset());
                TclAddWatchpointDialog dialog = new TclAddWatchpointDialog(part.getSite().getShell());
                try {
                    dialog.setExpression(document.get(reg.getOffset(), reg.getLength()));
                }
                catch (BadLocationException badLocationException) {}
                if (dialog.open() != 0) {
                    return;
                }
                fields = Collections.singletonList(dialog.getExpression());
            }
        }
        if (fields.isEmpty()) {
            this.report(ActionMessages.ToggleBreakpointAdapter_10, part);
            return;
        }
        for (Object element : fields) {
            String watchExpression;
            int start = -1;
            int end = -1;
            if (element instanceof IField) {
                IField field = (IField)element;
                ISourceRange range = field.getNameRange();
                start = range.getOffset();
                end = range.getOffset() + range.getLength();
                watchExpression = field.getElementName();
            } else if (element instanceof IScriptVariable) {
                watchExpression = ((IScriptVariable)element).getName();
            } else {
                if (!(element instanceof String)) continue;
                watchExpression = element.toString();
            }
            boolean found = false;
            int j = 0;
            while (j < breakpoints.length) {
                IScriptWatchpoint wp;
                IBreakpoint breakpoint = breakpoints[j];
                if (breakpoint instanceof IScriptWatchpoint && breakpoint.getMarker() != null && resource.equals((Object)breakpoint.getMarker().getResource()) && (wp = (IScriptWatchpoint)breakpoint).getLineNumber() == lineNumber && watchExpression.equals(wp.getFieldName())) {
                    breakpoint.delete();
                    found = true;
                }
                ++j;
            }
            if (found) continue;
            new ScriptWatchpoint(this.getDebugModelId(), (IResource)resource, resource.getType() == 1 ? resource.getLocation() : null, lineNumber, start, end, watchExpression);
        }
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public boolean canToggleSpawnpoints(IWorkbenchPart part, ITextSelection selection) {
        return !this.isRemote(part, (ISelection)selection);
    }

    public void toggleSpawnpoints(final IWorkbenchPart part, final ITextSelection selection) throws CoreException {
        Job job = new Job("Script Toggle Spawnpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor editor = TclToggleBreakpointAdapter.this.getTextEditor(part);
                if (editor != null) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        TclToggleBreakpointAdapter.this.report(null, part);
                        int lineNumber = selection.getStartLine() + 1;
                        ILineBreakpoint breakpoint = BreakpointUtils.findLineBreakpoint((ITextEditor)editor, (int)lineNumber);
                        if (breakpoint != null) {
                            breakpoint.delete();
                        } else {
                            IDocumentProvider documentProvider = editor.getDocumentProvider();
                            if (documentProvider == null) {
                                return Status.CANCEL_STATUS;
                            }
                            IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                            lineNumber = TclToggleBreakpointAdapter.access$2(document, lineNumber - 1, TclToggleBreakpointAdapter.this.getValidator()) + 1;
                            if (lineNumber != -1) {
                                if (BreakpointUtils.findLineBreakpoint((ITextEditor)editor, (int)lineNumber) == null) {
                                    BreakpointUtils.addSpawnpoint((ITextEditor)editor, (int)lineNumber);
                                } else {
                                    String template = Messages.ScriptToggleBreakpointAdapter_breakpointAlreadySetAtLine;
                                    TclToggleBreakpointAdapter.this.report(NLS.bind((String)template, (Object)Integer.toString(lineNumber)), part);
                                }
                            } else {
                                TclToggleBreakpointAdapter.this.report(Messages.ScriptToggleBreakpointAdapter_invalidBreakpointPosition, part);
                            }
                        }
                    }
                    catch (CoreException e) {
                        DLTKDebugUIPlugin.log((Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    static /* synthetic */ int access$2(IDocument iDocument, int n, IScriptBreakpointLineValidator iScriptBreakpointLineValidator) {
        return ScriptToggleBreakpointAdapter.findBreakpointLine((IDocument)iDocument, (int)n, (IScriptBreakpointLineValidator)iScriptBreakpointLineValidator);
    }
}

