/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.ExtendedTclMethodDeclaration;
import org.eclipse.dltk.tcl.core.extensions.ISelectionExtension;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclResolver;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclSelectionEngine;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclExInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodCallStatement;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodDeclaration;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclProcCallStatement;
import org.eclipse.dltk.xotcl.internal.core.XOTclResolver;
import org.eclipse.dltk.xotcl.internal.core.parser.XOTclCommandDetector;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclInstProc;

public class XOTclSelectionExtension
implements ISelectionExtension {
    public void selectionOnKeywordOrFunction(SelectionOnKeywordOrFunction key, TclSelectionEngine engine) {
        ASTNode originalNode = key.getOriginalNode();
        if (originalNode instanceof TclStatement) {
            this.processXOTclCommandCalls((TclStatement)originalNode, engine);
        }
    }

    private void processXOTclInstanceVariable(XOTclInstanceVariable node, TclSelectionEngine engine) {
        TypeDeclaration declaringType;
        IModelElement type;
        SimpleReference classInstanceName = node.getClassInstanceName();
        if (classInstanceName.sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= classInstanceName.sourceEnd() && (type = engine.findElementFromNode((ASTNode)(declaringType = node.getDeclaringType()))) != null) {
            engine.addSelectionElement(type);
        }
    }

    private void processXOTclCommandCalls(TclStatement node, TclSelectionEngine engine) {
        if (node.getCount() == 0) {
            return;
        }
        ASTNode parent = TclParseUtil.getPrevParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)node);
        String prefix = TclParseUtil.getElementFQN((ASTNode)parent, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule());
        Expression commandExpr = node.getAt(0);
        String command = TclParseUtil.getNameFromNode((ASTNode)commandExpr);
        IScriptProject project = engine.getScriptProject();
        if (command != null && command.startsWith("::")) {
            String name = command.substring(2);
            String[] split = name.split("::");
            IModelElement[] typeMixin = XOTclResolver.findTypeMixin(engine.tclNameToKey(name), split[split.length - 1], project);
            this.checkMixinTypeForMethod(node, commandExpr, typeMixin, prefix, engine);
        } else if (command != null) {
            String[] split = command.split("::");
            if (parent instanceof ModuleDeclaration) {
                IModelElement[] typeMixin = XOTclResolver.findTypeMixin(engine.tclNameToKey(command), split[split.length - 1], project);
                this.checkMixinTypeForMethod(node, commandExpr, typeMixin, prefix, engine);
            } else {
                IModelElement[] typeMixin = XOTclResolver.findTypeMixin(String.valueOf(prefix) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(command), split[split.length - 1], project);
                this.checkMixinTypeForMethod(node, commandExpr, typeMixin, prefix, engine);
            }
        }
    }

    private boolean checkMixinTypeForMethod(TclStatement node, Expression commandExpr, IModelElement[] typeMixin, String prefix, TclSelectionEngine engine) {
        int i = 0;
        while (i < typeMixin.length) {
            block14: {
                if (commandExpr.sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= commandExpr.sourceEnd()) {
                    engine.addSelectionElement(typeMixin[i]);
                    return true;
                }
                Expression callExpr = node.getAt(1);
                if (node.getCount() > 1 && typeMixin[i] instanceof IParent && callExpr.sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= callExpr.sourceEnd()) {
                    String call = TclParseUtil.getNameFromNode((ASTNode)callExpr);
                    IParent eParent = (IParent)typeMixin[i];
                    if (call != null) {
                        IModelElement[] children = null;
                        try {
                            children = eParent.getChildren();
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                        }
                        if (children != null) {
                            int j = 0;
                            while (j < children.length) {
                                if (children[j].getElementType() == 9 && children[j].getElementName().equals(call)) {
                                    engine.addSelectionElement(children[j]);
                                    return true;
                                }
                                ++j;
                            }
                        }
                        if (eParent instanceof IType) {
                            IType type = (IType)eParent;
                            try {
                                String[] superClasses = type.getSuperClasses();
                                if (superClasses != null) {
                                    int j = 0;
                                    while (j < superClasses.length) {
                                        IModelElement[] ptypeMixin = XOTclResolver.findTypeMixin(String.valueOf(prefix.length() > 0 ? String.valueOf(prefix) + IMixinRequestor.MIXIN_NAME_SEPARATOR : "") + engine.tclNameToKey(superClasses[j]), superClasses[j], engine.getScriptProject());
                                        String[] split = superClasses[j].split("::");
                                        this.checkMixinTypeForMethod(node, commandExpr, ptypeMixin, split[split.length - 1], engine);
                                        ++j;
                                    }
                                }
                            }
                            catch (ModelException e) {
                                if (!DLTKCore.DEBUG) break block14;
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private void processSelectXOTclMethod(XOTclProcCallStatement node, int position, TclSelectionEngine engine) {
        IModelElement parent;
        SimpleReference typeName = node.getInstNameRef();
        List levels = TclParseUtil.findLevelsTo((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)node);
        ASTNode nParent = (ASTNode)levels.get(levels.size() - 2);
        TypeDeclaration type = TclParseUtil.findXOTclTypeDeclarationFrom((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)nParent, (String)typeName.getName());
        if (type instanceof TypeDeclaration && (parent = engine.findElementFromNode((ASTNode)type)) != null && parent instanceof IParent) {
            if (node.getCallName().sourceStart() <= position && position <= node.getCallName().sourceEnd()) {
                IModelElement methodElement = TclResolver.findChildrenByName((String)node.getCallName().getName(), (IParent)((IParent)parent));
                engine.addSelectionElement(methodElement);
                return;
            }
            if (typeName.sourceStart() <= position && position <= typeName.sourceEnd()) {
                engine.addSelectionElement(parent);
            }
        }
    }

    private void processSelectXOTclMethodDeclaration(ExtendedTclMethodDeclaration node, int position, TclSelectionEngine engine) {
        ASTNode type = node.getDeclaringType();
        if (type instanceof TypeDeclaration) {
            SimpleReference ref = node.getTypeNameRef();
            IModelElement parent = engine.findElementFromNode(type);
            if (parent != null && parent instanceof IParent) {
                if (node.getNameStart() <= position && position <= node.getNameEnd()) {
                    IModelElement methodElement = TclResolver.findChildrenByName((String)node.getName(), (IParent)((IParent)parent));
                    engine.addSelectionElement(methodElement);
                    return;
                }
                if (ref.sourceStart() <= position && position <= ref.sourceEnd()) {
                    engine.addSelectionElement(parent);
                }
            }
        }
    }

    private void processSelectXOTclMethod(XOTclMethodCallStatement call, int position, TclSelectionEngine engine) {
        FieldDeclaration instanceVar = call.getInstanceVariable();
        SimpleReference callName = call.getCallName();
        SimpleReference instName = call.getInstNameRef();
        if (instanceVar != null && instanceVar instanceof XOTclInstanceVariable) {
            IModelElement parent;
            XOTclInstanceVariable instanceVariable;
            TypeDeclaration declaringType;
            if (callName.sourceStart() <= position && position <= callName.sourceEnd() && (declaringType = (instanceVariable = (XOTclInstanceVariable)instanceVar).getDeclaringType()) != null && (parent = engine.findElementFromNode((ASTNode)declaringType)) != null) {
                if (engine.checkMethodFrom(declaringType, callName, parent)) {
                    return;
                }
                String typeMixin = String.valueOf(TclParseUtil.getElementFQN((ASTNode)declaringType, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule())) + IMixinRequestor.MIXIN_NAME_SEPARATOR;
                engine.findMethodMixin(String.valueOf(typeMixin) + engine.tclNameToKey(callName.getName()), callName.getName());
                ASTNode nde = TclParseUtil.getPrevParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)declaringType);
                ArrayList supersToHandle = new ArrayList();
                engine.fillSuperClassesTo(declaringType, supersToHandle);
                TypeDeclaration prev = declaringType;
                while (supersToHandle.size() > 0) {
                    String superClassName = (String)supersToHandle.get(0);
                    supersToHandle.remove(0);
                    TypeDeclaration sType = TclParseUtil.findXOTclTypeDeclarationFrom((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)nde, (String)superClassName);
                    if (sType != null) {
                        prev = sType;
                        engine.fillSuperClassesTo(sType, supersToHandle);
                        IModelElement sParent = engine.findElementFromNode((ASTNode)sType);
                        if (engine.checkMethodFrom(sType, callName, sParent)) {
                            return;
                        }
                        String sTypeMixin = String.valueOf(TclParseUtil.getElementFQN((ASTNode)sType, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule())) + IMixinRequestor.MIXIN_NAME_SEPARATOR;
                        this.findXOTclMethodMixin(String.valueOf(sTypeMixin) + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                        continue;
                    }
                    String sTypeMixin = "";
                    if (prev != null) {
                        ASTNode prevParent = TclParseUtil.getPrevParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)prev);
                        sTypeMixin = prevParent instanceof ModuleDeclaration ? String.valueOf(engine.tclNameToKey(superClassName)) + IMixinRequestor.MIXIN_NAME_SEPARATOR : String.valueOf(TclParseUtil.getElementFQN((ASTNode)prevParent, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule())) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(superClassName) + IMixinRequestor.MIXIN_NAME_SEPARATOR;
                    }
                    this.findXOTclMethodMixin(String.valueOf(sTypeMixin) + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                    this.findXOTclMethodMixin(String.valueOf(engine.tclNameToKey(superClassName)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                }
            }
        } else if (instanceVar != null && instanceVar instanceof XOTclExInstanceVariable) {
            XOTclExInstanceVariable instanceVariable = (XOTclExInstanceVariable)instanceVar;
            IType type = (IType)instanceVariable.getDeclaringClassParameter().resolveElement();
            if (type != null && instName.sourceStart() <= position && position <= instName.sourceEnd()) {
                engine.addSelectionElement((IModelElement)type);
            } else if (type != null && callName.sourceStart() <= position && position <= callName.sourceEnd()) {
                String prevClass;
                String[] superClasses;
                ArrayList<String> supersToHandle;
                block20: {
                    String typeMixin = TclParseUtil.getFQNFromModelElement((IModelElement)type, (String)"::");
                    if (typeMixin.startsWith("::")) {
                        typeMixin = typeMixin.substring(2);
                    }
                    this.findXOTclMethodMixin(String.valueOf(engine.tclNameToKey(typeMixin)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                    supersToHandle = new ArrayList<String>();
                    superClasses = null;
                    try {
                        superClasses = type.getSuperClasses();
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block20;
                        e.printStackTrace();
                    }
                }
                if (superClasses != null) {
                    int i = 0;
                    while (i < superClasses.length) {
                        supersToHandle.add(superClasses[i]);
                        ++i;
                    }
                }
                if ((prevClass = type.getFullyQualifiedName()).startsWith("::")) {
                    prevClass = prevClass.substring(2);
                }
                while (supersToHandle.size() > 0) {
                    String superClassName = (String)supersToHandle.get(0);
                    supersToHandle.remove(0);
                    if (!superClassName.startsWith("::")) continue;
                    this.findXOTclMethodMixin(String.valueOf(superClassName.substring(2)) + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                }
            }
        }
        if (engine.getSelectionElementsSize() == 0 && instName.sourceStart() <= position && position <= instName.sourceEnd()) {
            engine.addElementFromASTNode((ASTNode)instanceVar);
        }
    }

    private void findXOTclMethodMixin(String pattern, String name, TclSelectionEngine engine) {
        IScriptProject project = engine.getScriptProject();
        IMixinElement[] find = TclMixinModel.getInstance().getMixin(project).find(String.valueOf(pattern) + "*");
        int pos = pattern.indexOf(IMixinRequestor.MIXIN_NAME_SEPARATOR);
        if (find.length == 0 && pos != -1) {
            String newPattern = pattern.substring(0, pos);
            find = TclMixinModel.getInstance().getMixin(project).find(String.valueOf(newPattern) + "*");
        }
        int i = 0;
        while (i < find.length) {
            Object[] allObjects = find[i].getAllObjects();
            int j = 0;
            while (j < allObjects.length) {
                XOTclInstProc field;
                if (allObjects[j] != null && allObjects[j] instanceof XOTclInstProc && name.equals((field = (XOTclInstProc)allObjects[j]).getName())) {
                    engine.addSelectionElement(field.getModelElement());
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void selectionOnAST(ASTNode node, TclSelectionEngine engine) {
        if (node instanceof XOTclMethodDeclaration) {
            this.processSelectXOTclMethodDeclaration((ExtendedTclMethodDeclaration)node, engine.getActualSelectionStart(), engine);
            if (engine.getSelectionElementsSize() > 0) {
                return;
            }
        }
    }

    public void selectionOnNode(ASTNode node, int position, TclSelectionEngine engine) {
        XOTclExInstanceVariable ex;
        XOTclCommandDetector.XOTclGlobalClassParameter declaringClassParameter;
        IModelElement resolveElement;
        if (node instanceof XOTclMethodCallStatement) {
            this.processSelectXOTclMethod((XOTclMethodCallStatement)node, position, engine);
        } else if (node instanceof XOTclProcCallStatement) {
            this.processSelectXOTclMethod((XOTclProcCallStatement)node, position, engine);
        } else if (node instanceof XOTclMethodDeclaration) {
            this.processSelectXOTclMethodDeclaration((ExtendedTclMethodDeclaration)node, engine.getActualSelectionStart(), engine);
        } else if (node instanceof TclStatement) {
            this.processXOTclCommandCalls((TclStatement)node, engine);
        } else if (node instanceof XOTclInstanceVariable) {
            this.processXOTclInstanceVariable((XOTclInstanceVariable)node, engine);
        } else if (node instanceof XOTclExInstanceVariable && (resolveElement = (declaringClassParameter = (ex = (XOTclExInstanceVariable)node).getDeclaringClassParameter()).resolveElement()) != null) {
            engine.addSelectionElement(resolveElement);
        }
    }

    public IModelElement findElementParent(ASTNode node, String name, IParent parent, TclSelectionEngine engine) {
        return null;
    }

    public void findVariables(String name, ASTNode parent, int beforePosition, TclSelectionEngine tclSelectionEngine) {
    }
}

