/*******************************************************************************
 * Copyright (c) 2010 xored software, Inc.  
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html  
 *
 * Contributors:
 *     xored software, Inc. - initial API and Implementation (Alex Panchenko)
 *******************************************************************************/
package org.eclipse.dltk.internal.javascript.validation;

public class FlowStatus {
	boolean returnValue;
	boolean returnWithoutValue;
	boolean noReturn;

	public void add(FlowStatus value) {
		if (value != null) {
			returnValue |= value.returnValue;
			returnValue |= value.returnWithoutValue;
			noReturn = value.noReturn
					|| (!value.returnValue && !value.returnWithoutValue);
		} else {
			noReturn = true;
		}
	}

	public boolean isReturned() {
		return (returnValue || returnWithoutValue) && !noReturn;
	}
}
