/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.LoopStatement;
import org.eclipse.dltk.javascript.ast.Statement;

public class ForInStatement
extends LoopStatement {
    private Keyword forKeyword;
    private Keyword inKeyword;
    private Expression item;
    private Expression iterator;
    private int LP = -1;
    private int RP = -1;

    public ForInStatement(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            Statement body;
            if (this.forKeyword != null) {
                this.forKeyword.traverse(visitor);
            }
            if (this.inKeyword != null) {
                this.inKeyword.traverse(visitor);
            }
            if (this.item != null) {
                this.item.traverse(visitor);
            }
            if (this.iterator != null) {
                this.iterator.traverse(visitor);
            }
            if ((body = this.getBody()) != null) {
                body.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getItem() {
        return this.item;
    }

    public void setItem(Expression item) {
        this.item = item;
    }

    public Expression getIterator() {
        return this.iterator;
    }

    public void setIterator(Expression iterator) {
        this.iterator = iterator;
    }

    public Keyword getForKeyword() {
        return this.forKeyword;
    }

    public void setForKeyword(Keyword keyword) {
        this.forKeyword = keyword;
    }

    public Keyword getInKeyword() {
        return this.inKeyword;
    }

    public void setInKeyword(Keyword keyword) {
        this.inKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("for");
        buffer.append(" (");
        buffer.append(this.getItem().toSourceString(indentationString));
        buffer.append(" ");
        buffer.append("in");
        buffer.append(" ");
        buffer.append(this.getIterator().toSourceString(indentationString));
        buffer.append(")");
        if (this.getBody() != null) {
            buffer.append("\n");
            buffer.append(this.getBody().toSourceString(indentationString));
        } else {
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

