/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ruby.core.Messages;
import org.eclipse.dltk.ruby.core.RubyPlugin;

public class PredefinedVariables {
    private static final String MESSAGE_PROPERTIES = "variables.properties";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String DOC = "doc";
    private static Map nameToTypeMap = new HashMap();
    private static Map nameToDocMap = new HashMap();

    static {
        try {
            URL url = RubyPlugin.getDefault().getBundle().getEntry(MESSAGE_PROPERTIES);
            BufferedInputStream input = null;
            try {
                input = new BufferedInputStream(url.openStream());
                Properties props = new Properties();
                props.load(input);
                Map parsedProps = PredefinedVariables.parseProperties(props, new String[]{NAME, TYPE, DOC});
                for (Object key : parsedProps.keySet()) {
                    Map entry = (Map)parsedProps.get(key);
                    String name = (String)entry.get(NAME);
                    String type = (String)entry.get(TYPE);
                    String doc = (String)entry.get(DOC);
                    nameToTypeMap.put(name, type);
                    nameToDocMap.put(name, doc);
                }
            }
            finally {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.ruby.core", 0, Messages.PredefinedVariables_unableToLoadRubyPredefinedVariables, (Throwable)e);
            RubyPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    static Map parseProperties(Properties props, String[] postfixes) {
        HashMap<String, HashMap<String, Object>> entries = new HashMap<String, HashMap<String, Object>>();
        for (String string : props.keySet()) {
            int i = 0;
            while (i < postfixes.length) {
                String postfix = postfixes[i];
                int index = string.indexOf("_" + postfix);
                if (index != -1) {
                    String name = string.substring(0, index);
                    HashMap<String, Object> entry = (HashMap<String, Object>)entries.get(name);
                    if (entry == null) {
                        entry = new HashMap<String, Object>();
                        entries.put(name, entry);
                    }
                    entry.put(postfix, props.get(string));
                }
                ++i;
            }
        }
        return entries;
    }

    public static String getTypeOf(String name) {
        return (String)nameToDocMap.get(name);
    }

    public static String getDocOf(String name) {
        return (String)nameToDocMap.get(name);
    }
}

