/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitionScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubySemanticUpdateWorker;
import org.eclipse.dltk.ruby.internal.ui.text.RubySourceViewerConfiguration;
import org.eclipse.dltk.ui.editor.highlighting.ASTSemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.texteditor.ITextEditor;

public class RubyTextTools
extends ScriptTextTools {
    public static final boolean USE_SEMANTIC_HL = true;
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__ruby_string", "__ruby_single_quote_string", "__ruby_percent_string", "__ruby_comment", "__ruby_doc"};

    public RubyTextTools(boolean autoDisposeOnDisplayDispose) {
        super("__ruby_partitioning", LEGAL_CONTENT_TYPES, autoDisposeOnDisplayDispose);
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        return new RubySourceViewerConfiguration(this.getColorManager(), preferenceStore, editor, partitioning);
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return new RubyPartitionScanner();
    }

    public SemanticHighlighting[] getSemanticHighlightings() {
        return RubySemanticUpdateWorker.getSemanticHighlightings();
    }

    public ISemanticHighlighter getSemanticPositionUpdater() {
        return new ASTSemanticHighlighter(){

            protected boolean doHighlighting(IModuleSource code) throws Exception {
                ModuleDeclaration declaration = (ModuleDeclaration)this.parseCode(code);
                if (declaration != null) {
                    declaration.traverse((ASTVisitor)new RubySemanticUpdateWorker((ISemanticHighlightingRequestor)this, code));
                    return true;
                }
                return false;
            }

            protected String getNature() {
                return "org.eclipse.dltk.ruby.core.nature";
            }
        };
    }
}

