/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.mixin;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.FunctionNode;
import com.xored.org.mozilla.javascript.Parser;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.io.CharArrayReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinParser;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptModuleDeclaration;
import org.eclipse.dltk.internal.javascript.parser.NullReporter;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptMixinParser
implements IMixinParser {
    private IMixinRequestor requestor;

    private void reportRefs(boolean signature, ISourceModule module) {
        block3: {
            char[] content = this.getContent(module);
            CompilerEnvirons cenv = new CompilerEnvirons();
            NullReporter reporter = new NullReporter();
            JavaScriptModuleDeclaration moduleDeclaration = new JavaScriptModuleDeclaration(content.length);
            Parser parser = new Parser(cenv, reporter);
            try {
                ScriptOrFnNode parse = parser.parse(new CharArrayReader(content), "", 0);
                TypeInferencer interferencer = new TypeInferencer((ModelElement)module, new ReferenceResolverContext(null, Collections.emptyMap()));
                interferencer.doInterferencing(parse, Integer.MAX_VALUE);
                this.processNode("", parse, signature, (IModelElement)module);
                HostCollection collection = interferencer.getCollection();
                moduleDeclaration.setCollection(collection);
                HashSet<IReference> hs = new HashSet<IReference>();
                for (IReference ref : collection.getReferences().values()) {
                    this.reportRef(ref, null, 0, hs);
                }
                Map<Integer, HostCollection> ms = interferencer.getFunctionMap();
                moduleDeclaration.setFunctionMap(ms);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private char[] getContent(ISourceModule module) {
        try {
            return module.getSourceAsCharArray();
        }
        catch (ModelException e1) {
            if (DLTKCore.DEBUG) {
                e1.printStackTrace();
            }
            return new char[0];
        }
    }

    private void reportRef(IReference ref, String sma, int level, Set<IReference> recursive) {
        Set<IReference> sm = ref.getChilds(false);
        String key = ref.getName();
        if (sma != null) {
            key = String.valueOf(sma) + '.' + key;
        }
        for (IReference refa : sm) {
            if (!recursive.add(refa)) continue;
            this.reportRef(refa, key, level + 1, recursive);
        }
        IMixinRequestor.ElementInfo elementInfo = new IMixinRequestor.ElementInfo();
        elementInfo.key = String.valueOf('{') + key.replace('.', '{');
        elementInfo.object = ref;
        this.requestor.reportElement(elementInfo);
    }

    private void processNode(String parent, ScriptOrFnNode parse, boolean signature, IModelElement parentElement) {
        FunctionNode n;
        int a = 0;
        while (a < parse.getFunctionCount()) {
            FunctionNode functionNode = parse.getFunctionNode(a);
            String functionName = functionNode.getFunctionName();
            if (functionName.length() > 0) {
                String key;
                IMixinRequestor.ElementInfo elementInfo = new IMixinRequestor.ElementInfo();
                elementInfo.key = key = String.valueOf(parent) + MixinModel.SEPARATOR + functionName;
                SourceMethod ms = new SourceMethod((ModelElement)parentElement, functionName);
                elementInfo.object = ms;
                this.requestor.reportElement(elementInfo);
                this.processNode(key, functionNode, signature, (IModelElement)ms);
            }
            ++a;
        }
        String[] paramsAndVars = parse.getParamAndVarNames();
        String[] params = new String[parse.getParamCount()];
        int i = 0;
        while (i < params.length) {
            params[i] = paramsAndVars[i];
            ++i;
        }
        int of = 0;
        if (parse instanceof FunctionNode && (n = (FunctionNode)parse).getFunctionType() != 1) {
            of = 1;
        }
        if (parent.length() == 0) {
            int i2 = params.length;
            while (i2 < paramsAndVars.length - of) {
                String key;
                String var;
                IElementRequestor.FieldInfo fieldInfo = new IElementRequestor.FieldInfo();
                fieldInfo.name = var = paramsAndVars[i2];
                IMixinRequestor.ElementInfo elementInfo = new IMixinRequestor.ElementInfo();
                elementInfo.key = key = String.valueOf(parent) + MixinModel.SEPARATOR + var;
                elementInfo.object = new SourceField((ModelElement)parentElement, var);
                this.requestor.reportElement(elementInfo);
                ++i2;
            }
        }
    }

    public void setRequirestor(IMixinRequestor requestor) {
        this.requestor = requestor;
    }

    public void parserSourceModule(boolean signature, ISourceModule module) {
        this.reportRefs(signature, module);
    }
}

