/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.builder;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IScriptBuilder {
    public static final int INCREMENTAL_BUILD = 0;
    public static final int FULL_BUILD = 1;

    public void initialize(IScriptProject var1);

    public IStatus buildResources(IScriptProject var1, List<IResource> var2, IProgressMonitor var3, int var4);

    public IStatus buildModelElements(IScriptProject var1, List<ISourceModule> var2, IProgressMonitor var3, int var4);

    public DependencyResponse getDependencies(IScriptProject var1, int var2, Set<ISourceModule> var3, Set<ISourceModule> var4, Set var5, Set var6);

    public void clean(IScriptProject var1, IProgressMonitor var2);

    public void endBuild(IScriptProject var1, IProgressMonitor var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DependencyResponse {
        public static final DependencyResponse FULL_LOCAL_BUILD = new DependencyResponse(){

            public boolean isFullLocalBuild() {
                return true;
            }
        };
        public static final DependencyResponse FULL_EXTERNAL_BUILD = new DependencyResponse(){

            public boolean isFullLocalBuild() {
                return true;
            }

            public boolean isFullExternalBuild() {
                return true;
            }
        };

        public boolean isFullLocalBuild() {
            return false;
        }

        public boolean isFullExternalBuild() {
            return false;
        }

        public Set<ISourceModule> getLocalDependencies() {
            return Collections.emptySet();
        }

        public Set<ISourceModule> getExternalDependencies() {
            return Collections.emptySet();
        }

        public static DependencyResponse createLocal(final Set<ISourceModule> localDependencies) {
            return new DependencyResponse(){

                @Override
                public Set<ISourceModule> getLocalDependencies() {
                    return localDependencies;
                }
            };
        }

        public static DependencyResponse create(final boolean fullLocal, final Set<ISourceModule> localDependencies, final Set<ISourceModule> externalDependencies) {
            return new DependencyResponse(){

                @Override
                public boolean isFullLocalBuild() {
                    return fullLocal;
                }

                @Override
                public Set<ISourceModule> getLocalDependencies() {
                    return !fullLocal && localDependencies != null ? localDependencies : Collections.emptySet();
                }

                @Override
                public Set<ISourceModule> getExternalDependencies() {
                    return externalDependencies != null ? externalDependencies : Collections.emptySet();
                }
            };
        }
    }
}

