/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parsers.jruby;

import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.ruby.internal.parsers.jruby.IDLTKRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SourcePosition;

public class DLTKRubyWarnings
implements IDLTKRubyWarnings {
    private final IProblemReporter problemReporter;

    public DLTKRubyWarnings(IProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public void warn(ISourcePosition position, String message) {
        DefaultProblem problem = new DefaultProblem(position.getFile(), message, 0, new String[0], 0, position.getStartOffset(), position.getEndOffset(), position.getStartLine());
        this.problemReporter.reportProblem((IProblem)problem);
    }

    public boolean isVerbose() {
        return false;
    }

    public void warning(ISourcePosition position, String message) {
        if (this.isVerbose()) {
            DefaultProblem problem = new DefaultProblem(position.getFile(), message, 0, new String[0], 0, position.getStartOffset(), position.getEndOffset(), position.getStartLine());
            this.problemReporter.reportProblem((IProblem)problem);
        }
    }

    public void error(ISourcePosition position, String message) {
        DefaultProblem problem = new DefaultProblem(position.getFile(), message, 0, new String[0], 1, position.getStartOffset(), position.getEndOffset(), position.getStartLine());
        this.problemReporter.reportProblem((IProblem)problem);
    }

    public void warn(String message) {
        this.warn(new SourcePosition(), message);
    }

    public void warning(String message) {
        this.warning(new SourcePosition(), message);
    }
}

