/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.utils.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInitializer
extends Expression {
    private final List<ObjectInitializerPart> initializers = new ArrayList<ObjectInitializerPart>();
    private int LC = -1;
    private int RC = -1;
    private IntList commas;
    private boolean multiline;

    public ObjectInitializer(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.initializers != null) {
                for (ASTNode aSTNode : this.initializers) {
                    aSTNode.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public List<ObjectInitializerPart> getInitializers() {
        return this.initializers;
    }

    public void addInitializer(ObjectInitializerPart initializer) {
        this.initializers.add(initializer);
    }

    public int getLC() {
        return this.LC;
    }

    public void setLC(int LC) {
        this.LC = LC;
    }

    public int getRC() {
        return this.RC;
    }

    public void setRC(int RC) {
        this.RC = RC;
    }

    public IntList getCommas() {
        return this.commas;
    }

    public void setCommas(IntList commas) {
        this.commas = commas;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LC > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RC > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.initializers.size() == 0 || this.commas.size() == this.initializers.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int i = 0;
        while (i < this.initializers.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(((ISourceable)((Object)this.initializers.get(i))).toSourceString(indentationString));
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }
}

