/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SourcesSelectionDialog
extends Dialog {
    private ListViewer sourcesViewer;
    private Set<String> sources = new HashSet<String>();
    private IEnvironmentUI environmentUI;
    private IEnvironment environment;
    private Button edit;
    private Button remove;
    private Button add;

    protected SourcesSelectionDialog(IShellProvider parentShell, IEnvironment environment) {
        super(parentShell);
        this.environment = environment;
        this.environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Files selection dialog.");
        Composite contents = (Composite)super.createDialogArea(parent);
        contents.setLayout((Layout)new GridLayout(2, false));
        this.sourcesViewer = new ListViewer(contents, 2052);
        this.sourcesViewer.setLabelProvider((IBaseLabelProvider)new SourcesLabelProvider());
        this.sourcesViewer.setContentProvider((IContentProvider)new SourcesContentProvider());
        this.sourcesViewer.setInput(this.sources);
        this.sourcesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(contents, 0);
        buttons.setLayoutData((Object)new GridData(-1, 4, false, true));
        buttons.setLayout((Layout)new GridLayout(1, false));
        this.add = new Button(buttons, 8);
        this.add.setText("Add");
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String file = SourcesSelectionDialog.this.environmentUI.selectFile(SourcesSelectionDialog.this.sourcesViewer.getList().getShell(), 0);
                if (file != null) {
                    SourcesSelectionDialog.this.sources.add(file);
                    SourcesSelectionDialog.this.sourcesViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.add.setLayoutData((Object)new GridData(4, -1, true, false));
        this.edit = new Button(buttons, 8);
        this.edit.setText("Edit");
        this.edit.setLayoutData((Object)new GridData(4, -1, true, false));
        this.remove = new Button(buttons, 8);
        this.remove.setText("Remove");
        this.remove.setLayoutData((Object)new GridData(4, -1, true, false));
        this.updateEnablement();
        this.sourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SourcesSelectionDialog.this.updateEnablement();
            }
        });
        this.getShell().layout();
        return contents;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        if (size.x < 400) {
            size.x = 400;
        }
        if (size.y < 300) {
            size.y = 300;
        }
        return size;
    }

    private String getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.sourcesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (String)selection.getFirstElement();
    }

    private void updateEnablement() {
        String path = this.getSelection();
        if (path == null) {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
        } else {
            this.edit.setEnabled(true);
            this.remove.setEnabled(true);
        }
    }

    public String[] getSources() {
        return this.sources.toArray(new String[this.sources.size()]);
    }

    private final class SourcesContentProvider
    implements IStructuredContentProvider {
        private SourcesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return SourcesSelectionDialog.this.sources.toArray();
        }
    }

    private final class SourcesLabelProvider
    extends LabelProvider {
        private SourcesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return "";
        }
    }
}

