/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.formatting;

import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class Indents {
    private Indents() {
    }

    public static int getTabWidth(Map options) {
        if (options == null) {
            throw new IllegalArgumentException();
        }
        return Indents.getIntValue(options, "org.eclipse.dltk.javascript.ui.formatter.tabulation.size", 4);
    }

    public static int getIndentWidth(Map options) {
        if (options == null) {
            throw new IllegalArgumentException();
        }
        int tabWidth = Indents.getTabWidth(options);
        boolean isMixedMode = "mixed".equals(options.get("org.eclipse.dltk.javascript.ui.formatter.tabulation.char"));
        if (isMixedMode) {
            return Indents.getIntValue(options, "org.eclipse.dltk.javascript.ui.formatter.indentation.size", tabWidth);
        }
        return tabWidth;
    }

    private static int getIntValue(Map options, String key, int def) {
        try {
            return Integer.parseInt((String)options.get(key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static int measureIndentUnits(CharSequence line, int tabWidth, int indentWidth) {
        if (indentWidth <= 0 || tabWidth < 0 || line == null) {
            throw new IllegalArgumentException();
        }
        int visualLength = Indents.measureIndentInSpaces(line, tabWidth);
        return visualLength / indentWidth;
    }

    public static String createIndentString(int indentationUnits, Map options) {
        int spaces;
        int tabs;
        if (options == null || indentationUnits < 0) {
            throw new IllegalArgumentException();
        }
        String tabChar = Indents.getStringValue(options, "org.eclipse.dltk.javascript.ui.formatter.tabulation.char", "tab");
        if ("space".equals(tabChar)) {
            tabs = 0;
            spaces = indentationUnits * Indents.getIndentWidth(options);
        } else if ("tab".equals(tabChar)) {
            tabs = indentationUnits;
            spaces = 0;
        } else if ("mixed".equals(tabChar)) {
            int tabWidth = Indents.getTabWidth(options);
            int spaceEquivalents = indentationUnits * Indents.getIndentWidth(options);
            if (tabWidth > 0) {
                tabs = spaceEquivalents / tabWidth;
                spaces = spaceEquivalents % tabWidth;
            } else {
                tabs = 0;
                spaces = spaceEquivalents;
            }
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        StringBuffer buffer = new StringBuffer(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public static String createFixIndentString(int fixIndentation, Map options) {
        int tabWidth;
        int spaces;
        int tabs;
        if (options == null || fixIndentation < 0) {
            throw new IllegalArgumentException();
        }
        String tabChar = Indents.getStringValue(options, "org.eclipse.dltk.javascript.ui.formatter.tabulation.char", "tab");
        if ("space".equals(tabChar)) {
            tabs = 0;
            spaces = fixIndentation;
        } else if ("tab".equals(tabChar)) {
            tabWidth = Indents.getTabWidth(options);
            tabs = fixIndentation / tabWidth;
            spaces = 0;
        } else if ("mixed".equals(tabChar)) {
            tabWidth = Indents.getTabWidth(options);
            if (tabWidth > 0) {
                tabs = fixIndentation / tabWidth;
                spaces = fixIndentation % tabWidth;
            } else {
                tabs = 0;
                spaces = fixIndentation;
            }
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        StringBuffer buffer = new StringBuffer(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    private static String getStringValue(Map options, String key, String def) {
        Object value = options.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return def;
    }

    public static int measureIndentInSpaces(CharSequence line, int tabWidth) {
        if (tabWidth < 0 || line == null) {
            throw new IllegalArgumentException();
        }
        int length = 0;
        int max = line.length();
        int i = 0;
        while (i < max) {
            char ch = line.charAt(i);
            if (ch == '\t') {
                int reminder = length % tabWidth;
                length += tabWidth - reminder;
            } else if (Indents.isIndentChar(ch)) {
                ++length;
            } else {
                return length;
            }
            ++i;
        }
        return length;
    }

    public static String extractIndentString(String line, int tabWidth, int indentWidth) {
        if (tabWidth < 0 || indentWidth <= 0 || line == null) {
            throw new IllegalArgumentException();
        }
        int size = line.length();
        int end = 0;
        int spaceEquivs = 0;
        int characters = 0;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = spaceEquivs % tabWidth;
                spaceEquivs += tabWidth - remainder;
                ++characters;
            } else {
                if (!Indents.isIndentChar(c)) break;
                ++spaceEquivs;
                ++characters;
            }
            if (spaceEquivs >= indentWidth) {
                end += characters;
                characters = 0;
                spaceEquivs %= indentWidth;
            }
            ++i;
        }
        if (end == 0) {
            return "";
        }
        if (end == size) {
            return line;
        }
        return line.substring(0, end);
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Indents.isLineDelimiterChar(ch);
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }
}

