/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.Keyword;

public class ForEachInStatement
extends ForInStatement
implements ISemicolonStatement {
    private Keyword eachKeyword;

    public ForEachInStatement(ASTNode parent) {
        super(parent);
    }

    public Keyword getEachKeyword() {
        return this.eachKeyword;
    }

    public void setEachKeyword(Keyword keyword) {
        this.eachKeyword = keyword;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getLP() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getRP() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getBody() != null && this.getSemicolonPosition() < 0 || this.getBody() == null && this.getSemicolonPosition() > -1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("for");
        buffer.append(' ');
        buffer.append("each");
        buffer.append(" (");
        buffer.append(this.getItem().toSourceString(indentationString));
        buffer.append(" ");
        buffer.append("in");
        buffer.append(" ");
        buffer.append(this.getIterator().toSourceString(indentationString));
        buffer.append(")");
        if (this.getBody() != null) {
            buffer.append("\n");
            buffer.append(this.getBody().toSourceString(indentationString));
            if (this.getSemicolonPosition() > -1) {
                buffer.append(';');
            }
        } else {
            if (this.getSemicolonPosition() > -1) {
                buffer.append(';');
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

