/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.debug.core.model.IScriptExceptionBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.AbstractScriptBreakpoint;

public class ScriptExceptionBreakpoint
extends AbstractScriptBreakpoint
implements IScriptExceptionBreakpoint {
    private static final String SCRIPT_EXCEPTION_BREAKPOINT = "org.eclipse.dltk.debug.scriptExceptionBreakpointMarker";
    protected static final String TYPE_NAME = "org.eclipse.dltk.debug.typeName";
    protected static final String CAUGHT = "org.eclipse.dltk.debug.caught";
    protected static final String UNCAUGHT = "org.eclipse.dltk.debug.uncaught";
    protected static final String SUSPEND_ON_SUBCLASSES = "org.eclipse.dltk.debug.suspend_on_subclasses";
    protected String fExceptionName = null;
    private static final String[] UPDATABLE_ATTRS = new String[]{"org.eclipse.debug.core.enabled", "org.eclipse.dltk.debug.hit_condition", "org.eclipse.dltk.debug.hit_value", "org.eclipse.dltk.debug.caught", "org.eclipse.dltk.debug.uncaught", "org.eclipse.dltk.debug.suspend_on_subclasses"};

    public ScriptExceptionBreakpoint() {
    }

    public ScriptExceptionBreakpoint(final String debugModelId, final IResource resource, final String exceptionName, final boolean caught, final boolean uncaught, final boolean add, final Map attributes) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ScriptExceptionBreakpoint.this.setMarker(resource.createMarker(ScriptExceptionBreakpoint.SCRIPT_EXCEPTION_BREAKPOINT));
                ScriptExceptionBreakpoint.this.addScriptBreakpointAttributes(attributes, debugModelId, true);
                attributes.put(ScriptExceptionBreakpoint.TYPE_NAME, exceptionName);
                attributes.put(ScriptExceptionBreakpoint.CAUGHT, caught);
                attributes.put(ScriptExceptionBreakpoint.UNCAUGHT, uncaught);
                ScriptExceptionBreakpoint.this.ensureMarker().setAttributes(attributes);
                ScriptExceptionBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public void setEnabled(boolean enabled) throws CoreException {
        if (enabled && !this.isCaught() && !this.isUncaught()) {
            this.setAttributes(new String[]{CAUGHT, UNCAUGHT}, new Object[]{Boolean.TRUE, Boolean.TRUE});
        }
        super.setEnabled(enabled);
    }

    public boolean isCaught() throws CoreException {
        return this.ensureMarker().getAttribute(CAUGHT, false);
    }

    public void setCaught(boolean caught) throws CoreException {
        if (caught == this.isCaught()) {
            return;
        }
        this.setAttribute(CAUGHT, caught);
        if (caught && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!caught && !this.isUncaught()) {
            this.setEnabled(false);
        }
    }

    public void setSuspendOnSubclasses(boolean suspend) throws CoreException {
        if (suspend != this.isSuspendOnSubclasses()) {
            this.setAttribute(SUSPEND_ON_SUBCLASSES, suspend);
        }
    }

    public boolean isSuspendOnSubclasses() throws CoreException {
        return this.ensureMarker().getAttribute(SUSPEND_ON_SUBCLASSES, false);
    }

    public boolean isUncaught() throws CoreException {
        return this.ensureMarker().getAttribute(UNCAUGHT, false);
    }

    public void setUncaught(boolean uncaught) throws CoreException {
        if (uncaught == this.isUncaught()) {
            return;
        }
        this.setAttribute(UNCAUGHT, uncaught);
        if (uncaught && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!uncaught && !this.isCaught()) {
            this.setEnabled(false);
        }
    }

    protected void setExceptionTypeName(String name) {
        this.fExceptionName = name;
    }

    public String getExceptionTypeName() {
        return this.fExceptionName;
    }

    public String[] getUpdatableAttributes() {
        return UPDATABLE_ATTRS;
    }

    public String getTypeName() throws CoreException {
        return (String)this.ensureMarker().getAttribute(TYPE_NAME);
    }
}

