/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.preferences.FieldValidators;
import org.eclipse.dltk.ui.preferences.ITextConverter;
import org.eclipse.dltk.ui.preferences.ImprovedAbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.NumberTransformer;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ScriptDebugConfigurationBlock
extends ImprovedAbstractConfigurationBlock {
    private PreferencePage preferencePage;
    private Preferences fUIPreferences;
    private static final int AUTO_SELECT_PORT_INDEX = 0;
    private static final int CUSTOM_PORT_INDEX = 1;
    private static final int AUTODETECT_BIND_ADDRESS_INDEX = 0;
    private Combo portCombo;
    private Text portText;
    private Button fAlertHCRFailed;
    private Button fAlertHCRNotSupported;
    private Combo ipCombo;

    protected List createOverlayKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "dbgp_bind_address"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "dbgp_port"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "dbgp_connection_timeout"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "dbgp_response_timeout"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.dltk.debug.ui.alert_hot_code_replace_failed"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.dltk.debug.ui.alert_hot_code_replace_not_supported"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.dltk.debug.catchOutput"));
        return overlayKeys;
    }

    public ScriptDebugConfigurationBlock(OverlayPreferenceStore store, PreferencePage mainPreferencePage) {
        super(store, mainPreferencePage);
        this.preferencePage = mainPreferencePage;
        this.fUIPreferences = DLTKDebugUIPlugin.getDefault().getPluginPreferences();
    }

    private Control createDbgpGroup(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)ScriptDebugPreferencesMessages.CommunicationLabel, (int)2, (int)1, (int)768);
        SWTFactory.createLabel((Composite)group, (String)ScriptDebugPreferencesMessages.ScriptDebugConfigurationBlock_BindAddress, (int)1);
        this.ipCombo = SWTFactory.createCombo((Composite)group, (int)2056, (int)0, (String[])new String[0]);
        this.ipCombo.add(ScriptDebugPreferencesMessages.ScriptDebugConfigurationBlock_AutoDetectBindAddress, 0);
        String[] ipAddresses = DLTKDebugPlugin.getLocalAddresses();
        int i = 0;
        while (i < ipAddresses.length) {
            this.ipCombo.add(ipAddresses[i]);
            ++i;
        }
        SWTFactory.createLabel((Composite)group, (String)ScriptDebugPreferencesMessages.PortLabel, (int)1);
        Composite portCompsite = SWTFactory.createComposite((Composite)group, (Font)group.getFont(), (int)2, (int)0, (int)768);
        GridLayout portCompsiteLayout = (GridLayout)portCompsite.getLayout();
        portCompsiteLayout.marginWidth = 0;
        portCompsiteLayout.marginHeight = 0;
        this.portCombo = SWTFactory.createCombo((Composite)portCompsite, (int)2056, (int)0, (String[])new String[0]);
        this.portCombo.add(ScriptDebugPreferencesMessages.AutoSelectLabel, 0);
        this.portCombo.add(ScriptDebugPreferencesMessages.CustomLabel, 1);
        this.portText = SWTFactory.createText((Composite)portCompsite, (int)2048, (int)0, (String)"");
        this.bindControl(this.portText, FieldValidators.PORT_VALIDATOR);
        this.portCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isCustom = ScriptDebugConfigurationBlock.this.portCombo.getSelectionIndex() == 1;
                ScriptDebugConfigurationBlock.this.portText.setEnabled(isCustom);
                if (!isCustom) {
                    ScriptDebugConfigurationBlock.this.portText.setText("");
                } else {
                    ScriptDebugConfigurationBlock.this.portText.setText(ScriptDebugConfigurationBlock.this.portText.getText());
                }
            }
        });
        NumberTransformer timeoutTransformer = new NumberTransformer(){

            protected int convertPreference(int value) {
                return value / 1000;
            }

            protected int convertInput(int input) {
                return input * 1000;
            }
        };
        SWTFactory.createLabel((Composite)group, (String)ScriptDebugPreferencesMessages.ConnectionTimeoutLabel, (int)1);
        Text connectionTimeout = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.bindControl(connectionTimeout, "dbgp_connection_timeout", FieldValidators.POSITIVE_NUMBER_VALIDATOR, (ITextConverter)timeoutTransformer);
        SWTFactory.createLabel((Composite)group, (String)ScriptDebugPreferencesMessages.ResponseTimeoutLabel, (int)1);
        Text responseTimeout = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.bindControl(responseTimeout, "dbgp_response_timeout", FieldValidators.POSITIVE_NUMBER_VALIDATOR, (ITextConverter)timeoutTransformer);
        return group;
    }

    private Control createHotCodeReplaceGroup(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)ScriptDebugPreferencesMessages.HCRLabel, (int)1, (int)1, (int)768);
        boolean alertHcrFailed = this.fUIPreferences.getBoolean("org.eclipse.dltk.debug.ui.alert_hot_code_replace_failed");
        this.fAlertHCRFailed = SWTFactory.createCheckButton((Composite)group, (String)ScriptDebugPreferencesMessages.HCRFailedLabel, null, (boolean)alertHcrFailed, (int)1);
        boolean alertHcrNotSupported = this.fUIPreferences.getBoolean("org.eclipse.dltk.debug.ui.alert_hot_code_replace_not_supported");
        this.fAlertHCRNotSupported = SWTFactory.createCheckButton((Composite)group, (String)ScriptDebugPreferencesMessages.HCRNotSupportedLabel, null, (boolean)alertHcrNotSupported, (int)1);
        return group;
    }

    private void createScriptLanguagesLinks(Composite parent) {
        IDLTKUILanguageToolkit[] toolkits = DLTKUILanguageManager.getLanguageToolkits();
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768);
        int i = 0;
        while (i < toolkits.length) {
            IDLTKUILanguageToolkit toolkit = toolkits[i];
            String pageId = toolkit.getDebugPreferencePage();
            if (pageId != null) {
                String languageName = toolkit.getCoreToolkit().getLanguageName();
                String message = NLS.bind((String)ScriptDebugPreferencesMessages.LinkToLanguageDebugOptions, (Object[])new Object[]{"{0}", languageName});
                PreferenceLinkArea area = new PreferenceLinkArea(composite, 0, pageId, message, (IWorkbenchPreferenceContainer)this.preferencePage.getContainer(), null);
                area.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
            }
            ++i;
        }
    }

    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768);
        this.createDbgpGroup(composite);
        this.createHotCodeReplaceGroup(composite);
        this.createLogging(composite);
        this.createScriptLanguagesLinks(composite);
        return composite;
    }

    private void createLogging(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"Logging", (int)1, (int)1, (int)768);
        this.bindControl(SWTFactory.createCheckButton((Composite)group, (String)"Catch output"), "org.eclipse.dltk.debug.catchOutput");
    }

    public void initialize() {
        super.initialize();
        IPreferenceStore store = this.getPreferenceStore();
        String address = store.getString("dbgp_bind_address");
        int index = this.ipCombo.indexOf(address);
        if (index < 0) {
            index = 0;
        }
        this.ipCombo.select(index);
        int port = store.getInt("dbgp_port");
        if (port == -1) {
            this.portText.setEnabled(false);
            this.portText.setText("");
            this.portCombo.select(0);
        } else {
            this.portText.setEnabled(true);
            this.portText.setText(Integer.toString(port));
            this.portCombo.select(1);
        }
    }

    public void performDefaults() {
        this.fAlertHCRFailed.setSelection(true);
        this.fAlertHCRNotSupported.setSelection(true);
        super.performDefaults();
    }

    public void performOk() {
        super.performOk();
        this.fUIPreferences.setValue("org.eclipse.dltk.debug.ui.alert_hot_code_replace_failed", this.fAlertHCRFailed.getSelection());
        this.fUIPreferences.setValue("org.eclipse.dltk.debug.ui.alert_hot_code_replace_not_supported", this.fAlertHCRNotSupported.getSelection());
        IPreferenceStore store = this.getPreferenceStore();
        if (this.ipCombo.getSelectionIndex() == 0) {
            store.setValue("dbgp_bind_address", "autodetect");
        } else {
            store.setValue("dbgp_bind_address", this.ipCombo.getText());
        }
        if (this.portCombo.getSelectionIndex() == 0) {
            store.setValue("dbgp_port", -1);
        } else {
            store.setValue("dbgp_port", Integer.parseInt(this.portText.getText()));
        }
    }
}

