/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.SwitchComponent;

public class CaseClause
extends SwitchComponent {
    private Keyword caseKeyword;
    private Expression condition;

    public CaseClause(ASTNode parent) {
        super(parent);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Keyword getCaseKeyword() {
        return this.caseKeyword;
    }

    public void setCaseKeyword(Keyword keyword) {
        this.caseKeyword = keyword;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("case");
        buffer.append(" ");
        buffer.append(this.getCondition().toSourceString(indentationString));
        buffer.append(":\n");
        CaseClause.toSourceString(this.getStatements(), buffer, String.valueOf(indentationString) + "    ");
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }

    public Keyword getKeyword() {
        return this.getCaseKeyword();
    }
}

