/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchConstants;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.core.tests.model.TestSearchResults;

public class AbstractSingleProjectSearchTests
extends AbstractModelTests
implements IDLTKSearchConstants {
    protected static final int EXACT_RULE = 8;
    private final String scriptProjectName;

    protected AbstractSingleProjectSearchTests(String testPluginName, String testName, String scriptProjectName) {
        super(testPluginName, testName);
        this.scriptProjectName = scriptProjectName;
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpScriptProject(this.scriptProjectName);
        AbstractSingleProjectSearchTests.waitUntilIndexesReady();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(this.scriptProjectName);
        super.tearDownSuite();
    }

    protected TestSearchResults search(String patternString, int searchFor, int limitTo) throws CoreException {
        return this.search(patternString, searchFor, limitTo, 8);
    }

    protected TestSearchResults search(String patternString, int searchFor, int limitTo, int matchRule) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.getScriptProject(this.scriptProjectName));
        IDLTKLanguageToolkit toolkit = scope.getLanguageToolkit();
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)toolkit);
        AbstractSingleProjectSearchTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        TestSearchResults results = new TestSearchResults();
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        new SearchEngine().search(pattern, participants, scope, (SearchRequestor)results, null);
        return results;
    }
}

