/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceElementParserExtension;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelProviderManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.PackageDeclaration;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceModuleElementInfo;
import org.eclipse.dltk.internal.core.SourceModuleStructureRequestor;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.StructureBuilder;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public abstract class AbstractSourceModule
extends Openable
implements org.eclipse.dltk.core.ISourceModule,
ISourceModule {
    private static final boolean DEBUG_PRINT_MODEL = DLTKCore.DEBUG_PRINT_MODEL;
    private String name;
    private WorkingCopyOwner owner;
    private boolean readOnly;

    protected AbstractSourceModule(ModelElement parent, String name, WorkingCopyOwner owner) {
        this(parent, name, owner, false);
    }

    protected AbstractSourceModule(ModelElement parent, String name, WorkingCopyOwner owner, boolean readOnly) {
        super(parent);
        this.name = name;
        this.owner = owner;
        this.readOnly = readOnly;
    }

    public IModelElement[] codeSelect(int offset, int length) throws ModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IModelElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws ModelException {
        return super.codeSelect(this, offset, length, owner);
    }

    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().copy(elements, containers, null, renamings, replace, monitor);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractSourceModule) {
            AbstractSourceModule other = (AbstractSourceModule)obj;
            return this.owner.equals(other.owner) && super.equals(obj);
        }
        return false;
    }

    public boolean exists() {
        try {
            return this.isPrimary() && this.validateSourceModule(this.getResource()).isOK();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IType[] getAllTypes() throws ModelException {
        IType[] types = this.getTypes();
        ArrayList<IType> allTypes = new ArrayList<IType>(types.length);
        ArrayList<IType> typesToTraverse = new ArrayList<IType>(types.length);
        int i = 0;
        while (i < types.length) {
            typesToTraverse.add(types[i]);
            ++i;
        }
        while (!typesToTraverse.isEmpty()) {
            IType type = (IType)typesToTraverse.get(0);
            typesToTraverse.remove(type);
            allTypes.add(type);
            types = type.getTypes();
            i = 0;
            while (i < types.length) {
                typesToTraverse.add(types[i]);
                ++i;
            }
        }
        IType[] arrayOfAllTypes = new IType[allTypes.size()];
        allTypes.toArray(arrayOfAllTypes);
        return arrayOfAllTypes;
    }

    public IModelElement getElementAt(int position) throws ModelException {
        IModelElement e = this.getSourceElementAt(position);
        if (e == this) {
            return null;
        }
        return e;
    }

    public String getElementName() {
        return this.name;
    }

    public int getElementType() {
        return 5;
    }

    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    public IField[] getFields() throws ModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '#': {
                if (!DLTKCore.DEBUG) break;
                System.err.println("Add import support in SourceModule getHandleFromMemento");
                break;
            }
            case '%': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String pkgName = memento.nextToken();
                ModelElement pkgDecl = (ModelElement)((Object)this.getPackageDeclaration(pkgName));
                return pkgDecl.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                ModelElement type = (ModelElement)((Object)this.getType(typeName));
                return type.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String methodName = memento.nextToken();
                ModelElement method = (ModelElement)((Object)this.getMethod(methodName));
                return method.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String field = memento.nextToken();
                ModelElement fieldE = (ModelElement)((Object)this.getField(field));
                return fieldE.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento(memento, this, this.owner);
            }
        }
        return null;
    }

    public IMethod getMethod(String selector) {
        return new SourceMethod(this, selector);
    }

    public IMethod[] getMethods() throws ModelException {
        ArrayList list = this.getChildrenOfType(9);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    public IModelElement getModelElement() {
        return this;
    }

    public WorkingCopyOwner getOwner() {
        return this.isPrimary() || !this.isWorkingCopy() ? null : this.owner;
    }

    public IPackageDeclaration getPackageDeclaration(String pkg) {
        return new PackageDeclaration(this, pkg);
    }

    public IPackageDeclaration[] getPackageDeclarations() throws ModelException {
        ArrayList list = this.getChildrenOfType(10);
        IPackageDeclaration[] array = new IPackageDeclaration[list.size()];
        list.toArray(array);
        return array;
    }

    public IPath getPath() {
        IProjectFragment root = this.getProjectFragment();
        if (root != null && root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public org.eclipse.dltk.core.ISourceModule getPrimary() {
        return (org.eclipse.dltk.core.ISourceModule)this.getPrimaryElement(true);
    }

    public IModelElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return this.getOriginalSourceModule();
    }

    public IPath getScriptFolder() {
        return null;
    }

    public String getSource() throws ModelException {
        IBuffer buffer = this.getBufferNotOpen();
        if (buffer == null) {
            return new String(this.getBufferContent());
        }
        return buffer.getContents();
    }

    public char[] getSourceAsCharArray() throws ModelException {
        IBuffer buffer = this.getBufferNotOpen();
        if (buffer == null) {
            return this.getBufferContent();
        }
        return buffer.getContents().toCharArray();
    }

    public String getSourceContents() {
        try {
            return this.getSource();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return "";
        }
    }

    public char[] getContentsAsCharArray() {
        try {
            return this.getSourceAsCharArray();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return CharOperation.NO_CHAR;
        }
    }

    public org.eclipse.dltk.core.ISourceModule getSourceModule() {
        return this;
    }

    public ISourceRange getSourceRange() throws ModelException {
        return ((SourceModuleElementInfo)this.getElementInfo()).getSourceRange();
    }

    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    public IType[] getTypes() throws ModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public IResource getUnderlyingResource() throws ModelException {
        if (this.isWorkingCopy() && !this.isPrimary()) {
            return null;
        }
        return super.getUnderlyingResource();
    }

    public org.eclipse.dltk.core.ISourceModule getWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this.getWorkingCopy(new WorkingCopyOwner(){}, null, monitor);
    }

    public boolean isBuiltin() {
        return false;
    }

    public boolean isConsistent() {
        return !ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().contains(this);
    }

    public boolean isPrimary() {
        return this.owner == DefaultWorkingCopyOwner.PRIMARY;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void printNode(CorePrinter output) {
        output.formatPrint(String.valueOf(this.getModuleType()) + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    protected abstract char[] getBufferContent() throws ModelException;

    protected abstract String getModuleType();

    protected abstract String getNatureId() throws CoreException;

    protected abstract org.eclipse.dltk.core.ISourceModule getOriginalSourceModule();

    protected ModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return null;
    }

    private AccumulatingProblemReporter getAccumulatingProblemReporter() {
        IScriptProject project;
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = this.getPerWorkingCopyInfo();
        if (perWorkingCopyInfo != null && perWorkingCopyInfo.isActive() && (project = this.getScriptProject()) != null && (" ".equals(project.getProject().getName()) || ScriptProject.hasScriptNature(project.getProject()))) {
            return new AccumulatingProblemReporter(perWorkingCopyInfo);
        }
        return null;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        try {
            IBuffer buffer;
            IStatus status;
            if (!this.isWorkingCopy() && !(status = this.validateSourceModule(underlyingResource)).isOK()) {
                throw this.newModelException(status);
            }
            if (this.preventReopen()) {
                throw this.newNotPresentException();
            }
            SourceModuleElementInfo moduleInfo = (SourceModuleElementInfo)info;
            if (this.hasBuffer() && (buffer = this.getBufferManager().getBuffer(this)) == null) {
                this.openBuffer(pm, moduleInfo);
            }
            SourceModuleStructureRequestor requestor = new SourceModuleStructureRequestor(this, moduleInfo, newElements);
            String natureId = this.getNatureId();
            if (natureId == null) {
                throw new ModelException(new ModelStatus(983));
            }
            ISourceElementParser parser = this.getSourceElementParser(natureId);
            if (!this.isReadOnly() && parser instanceof ISourceElementParserExtension) {
                ((ISourceElementParserExtension)((Object)parser)).setScriptProject(this.getScriptProject());
            }
            parser.setRequestor(requestor);
            AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
            parser.setReporter(problemReporter);
            SourceParserUtil.parseSourceModule(this, parser);
            if (problemReporter != null) {
                if (!problemReporter.hasErrors()) {
                    StructureBuilder.build(natureId, this, problemReporter);
                }
                problemReporter.reportToRequestor();
            }
            if (DEBUG_PRINT_MODEL) {
                System.out.println("Source Module Debug print:");
                CorePrinter printer = new CorePrinter(System.out);
                this.printNode(printer);
                printer.flush();
            }
            if (underlyingResource == null) {
                underlyingResource = this.getResource();
            }
            if (underlyingResource != null) {
                moduleInfo.timestamp = ((IFile)underlyingResource).getModificationStamp();
            }
            ArrayList childrenSet = new ArrayList(Arrays.asList(moduleInfo.getChildren()));
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
            IModelProvider[] providers = ModelProviderManager.getProviders(toolkit.getNatureId());
            if (providers != null) {
                int i = 0;
                while (i < providers.length) {
                    providers[i].provideModelChanges(this, childrenSet);
                    ++i;
                }
            }
            moduleInfo.setChildren(childrenSet.toArray(new IModelElement[childrenSet.size()]));
            return moduleInfo.isStructureKnown();
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected Object createElementInfo() {
        return new SourceModuleElementInfo();
    }

    protected char getHandleMementoDelimiter() {
        return '{';
    }

    protected ISourceElementParser getSourceElementParser(String natureId) throws CoreException {
        return DLTKLanguageManager.getSourceElementParser(natureId);
    }

    protected boolean hasBuffer() {
        return true;
    }

    protected final IDLTKLanguageToolkit lookupLanguageToolkit(Object object) throws CoreException {
        IDLTKLanguageToolkit toolkit = null;
        if (object instanceof IPath) {
            toolkit = DLTKLanguageManager.findToolkit((IPath)object);
        } else if (object instanceof IResource) {
            toolkit = DLTKLanguageManager.findToolkit(this.getParent(), (IResource)object, true);
        } else if (object instanceof IScriptProject) {
            toolkit = DLTKLanguageManager.getLanguageToolkit((IScriptProject)object);
        } else if (object instanceof IModelElement) {
            toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)object);
        }
        return toolkit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws ModelException {
        IBuffer buffer;
        BufferManager bufManager = this.getBufferManager();
        boolean isWorkingCopy = this.isWorkingCopy();
        IBuffer iBuffer = buffer = isWorkingCopy ? this.owner.createBuffer(this) : BufferManager.createBuffer(this);
        if (buffer == null) {
            return null;
        }
        BufferManager bufferManager = bufManager;
        synchronized (bufferManager) {
            IBuffer existingBuffer = bufManager.getBuffer(this);
            if (existingBuffer != null) {
                return existingBuffer;
            }
            char[] chars = buffer.getCharacters();
            if (chars == null || chars.length == 0) {
                if (isWorkingCopy) {
                    org.eclipse.dltk.core.ISourceModule original;
                    if (!this.isPrimary() && (original = this.getOriginalSourceModule()).isOpen()) {
                        buffer.setContents(original.getSource());
                    } else {
                        char[] content = this.getBufferContent();
                        buffer.setContents(content);
                    }
                } else {
                    char[] content = this.getBufferContent();
                    buffer.setContents(content);
                }
            }
            bufManager.addBuffer(buffer);
            buffer.addBufferChangedListener(this);
        }
        return buffer;
    }

    protected void openParent(Object childInfo, HashMap newElements, IProgressMonitor pm) throws ModelException {
        if (!this.isWorkingCopy()) {
            super.openParent(childInfo, newElements, pm);
        }
    }

    protected boolean preventReopen() {
        return !this.isPrimary();
    }

    protected IStatus validateSourceModule(IResource resource) throws CoreException {
        IStatus status;
        IProjectFragment root = this.getProjectFragment();
        try {
            if (root.getKind() != 1) {
                return new ModelStatus(967, root);
            }
        }
        catch (ModelException e) {
            return e.getModelStatus();
        }
        if (resource != null) {
            if (Util.isExcluded(resource, root)) {
                return new ModelStatus(1006, this);
            }
            if (!resource.isAccessible()) {
                return new ModelStatus(969, this);
            }
        }
        IDLTKLanguageToolkit toolkit = null;
        if (!root.isArchive()) {
            toolkit = this.lookupLanguageToolkit(this);
        }
        if ((status = this.validateSourceModule(toolkit, resource)) != null) {
            return status;
        }
        return new ModelStatus(995, root);
    }

    protected IStatus validateSourceModule(IDLTKLanguageToolkit toolkit, IResource resource) {
        if (toolkit == null) {
            toolkit = DLTKLanguageManager.findToolkit(this.getParent(), resource, true);
        }
        if (toolkit != null && DLTKContentTypeManager.isValidResourceForContentType(toolkit, resource)) {
            return IModelStatus.VERIFIED_OK;
        }
        return null;
    }
}

