/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;

public class ExternalProjectFragmentRequest
extends IndexRequest {
    protected final IProjectFragment fragment;
    protected final IDLTKLanguageToolkit toolkit;

    public ExternalProjectFragmentRequest(IProjectIndexer indexer, IProjectFragment fragment, IDLTKLanguageToolkit toolkit) {
        super(indexer);
        this.fragment = fragment;
        this.toolkit = toolkit;
    }

    protected String getName() {
        return this.fragment.getElementName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void run() throws CoreException, IOException {
        Set modules = this.getExternalSourceModules();
        Index index = this.getIndexer().getProjectFragmentIndex(this.fragment);
        if (index == null) {
            return;
        }
        IPath containerPath = this.fragment.getPath();
        List changes = this.checkChanges(index, modules, containerPath, this.getEnvironment());
        if (changes.isEmpty()) {
            return;
        }
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            try {
                Iterator i = changes.iterator();
                while (!this.isCancelled) {
                    if (!i.hasNext()) {
                        return;
                    }
                    Object change = i.next();
                    if (change instanceof String) {
                        index.remove((String)change);
                        continue;
                    }
                    this.getIndexer().indexSourceModule(index, this.toolkit, (ISourceModule)change, containerPath);
                }
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    try {
                        index.save();
                        return;
                    }
                    catch (IOException e2) {
                        DLTKCore.error("error saving index", e2);
                        imon.exitWrite();
                        return;
                    }
                }
                finally {
                    imon.exitWrite();
                }
            }
        }
        finally {
            block24: {
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        DLTKCore.error("error saving index", e);
                        imon.exitWrite();
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    imon.exitWrite();
                    throw throwable;
                }
                imon.exitWrite();
            }
        }
    }

    protected IEnvironment getEnvironment() {
        return EnvironmentManager.getEnvironment(this.fragment);
    }

    private Set getExternalSourceModules() throws ModelException {
        ExternalModuleVisitor visitor = new ExternalModuleVisitor();
        this.fragment.accept(visitor);
        return visitor.modules;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalProjectFragmentRequest other = (ExternalProjectFragmentRequest)obj;
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment));
    }

    static class ExternalModuleVisitor
    implements IModelElementVisitor {
        final Set modules = new HashSet();

        ExternalModuleVisitor() {
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                if (element instanceof ExternalSourceModule || element instanceof BuiltinSourceModule) {
                    this.modules.add(element);
                }
                return false;
            }
            return true;
        }
    }
}

