/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.net.URI;
import java.util.Map;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.IDbgpFeature;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.breakpoints.DbgpBreakpointConfig;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.commands.IDbgpBreakpointCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpContextCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpContinuationCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpDataTypeCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpFeatureCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpPropertyCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpSourceCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpStackCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpStatusCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpStreamCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.commands.DbgpBreakpointCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpContextCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpContinuationCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpDataTypeCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpFeatureCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpPropertyCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpSourceCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpStackCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpStatusCommands;
import org.eclipse.dltk.dbgp.internal.commands.DbgpStreamCommands;

public class DbgpCoreCommands
implements IDbgpCoreCommands {
    private final IDbgpFeatureCommands featureCommands;
    private final IDbgpStatusCommands statusCommands;
    private final IDbgpBreakpointCommands breakpointCommands;
    private final IDbgpSourceCommands sourceCommands;
    private final IDbgpContextCommands contextCommands;
    private final IDbgpStackCommands stackCommands;
    private final IDbgpContinuationCommands continuationCommands;
    private final IDbgpStreamCommands streamCommands;
    private final IDbgpDataTypeCommands dataTypeCommands;
    private final IDbgpPropertyCommands propertyCommands;

    public DbgpCoreCommands(IDbgpCommunicator communicator) {
        this.featureCommands = new DbgpFeatureCommands(communicator);
        this.statusCommands = new DbgpStatusCommands(communicator);
        this.breakpointCommands = new DbgpBreakpointCommands(communicator);
        this.sourceCommands = new DbgpSourceCommands(communicator);
        this.contextCommands = new DbgpContextCommands(communicator);
        this.stackCommands = new DbgpStackCommands(communicator);
        this.continuationCommands = new DbgpContinuationCommands(communicator);
        this.streamCommands = new DbgpStreamCommands(communicator);
        this.propertyCommands = new DbgpPropertyCommands(communicator);
        this.dataTypeCommands = new DbgpDataTypeCommands(communicator);
    }

    public IDbgpFeature getFeature(String featureName) throws DbgpException {
        return this.featureCommands.getFeature(featureName);
    }

    public boolean setFeature(String featureName, String featureValue) throws DbgpException {
        return this.featureCommands.setFeature(featureName, featureValue);
    }

    public IDbgpBreakpoint getBreakpoint(String id) throws DbgpException {
        return this.breakpointCommands.getBreakpoint(id);
    }

    public IDbgpBreakpoint[] getBreakpoints() throws DbgpException {
        return this.breakpointCommands.getBreakpoints();
    }

    public void removeBreakpoint(String id) throws DbgpException {
        this.breakpointCommands.removeBreakpoint(id);
    }

    public String setCallBreakpoint(URI uri, String function, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setCallBreakpoint(uri, function, info);
    }

    public String setConditionalBreakpoint(URI uri, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setConditionalBreakpoint(uri, info);
    }

    public String setConditionalBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setConditionalBreakpoint(uri, lineNumber, info);
    }

    public String setExceptionBreakpoint(String exception, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setExceptionBreakpoint(exception, info);
    }

    public String setLineBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setLineBreakpoint(uri, lineNumber, info);
    }

    public String setReturnBreakpoint(URI uri, String function, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setReturnBreakpoint(uri, function, info);
    }

    public String setWatchBreakpoint(URI uri, int line, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setWatchBreakpoint(uri, line, info);
    }

    public void updateBreakpoint(String id, DbgpBreakpointConfig config) throws DbgpException {
        this.breakpointCommands.updateBreakpoint(id, config);
    }

    public IDbgpStatus detach() throws DbgpException {
        return this.continuationCommands.detach();
    }

    public IDbgpStatus run() throws DbgpException {
        return this.continuationCommands.run();
    }

    public IDbgpStatus stepInto() throws DbgpException {
        return this.continuationCommands.stepInto();
    }

    public IDbgpStatus stepOut() throws DbgpException {
        return this.continuationCommands.stepOut();
    }

    public IDbgpStatus stepOver() throws DbgpException {
        return this.continuationCommands.stepOver();
    }

    public IDbgpStatus stop() throws DbgpException {
        return this.continuationCommands.stop();
    }

    public Map getTypeMap() throws DbgpException {
        return this.dataTypeCommands.getTypeMap();
    }

    public String getSource(URI uri) throws DbgpException {
        return this.sourceCommands.getSource(uri);
    }

    public String getSource(URI uri, int beginLine) throws DbgpException {
        return this.sourceCommands.getSource(uri, beginLine);
    }

    public String getSource(URI uri, int beginLine, int endLine) throws DbgpException {
        return this.sourceCommands.getSource(uri, beginLine, endLine);
    }

    public IDbgpStatus getStatus() throws DbgpException {
        return this.statusCommands.getStatus();
    }

    public IDbgpStackLevel getStackLevel(int stackDepth) throws DbgpException {
        return this.stackCommands.getStackLevel(stackDepth);
    }

    public IDbgpStackLevel[] getStackLevels() throws DbgpException {
        return this.stackCommands.getStackLevels();
    }

    public int getStackDepth() throws DbgpException {
        return this.stackCommands.getStackDepth();
    }

    public Map getContextNames(int stackDepth) throws DbgpException {
        return this.contextCommands.getContextNames(stackDepth);
    }

    public IDbgpProperty[] getContextProperties(int stackDepth) throws DbgpException {
        return this.contextCommands.getContextProperties(stackDepth);
    }

    public IDbgpProperty[] getContextProperties(int stackDepth, int contextId) throws DbgpException {
        return this.contextCommands.getContextProperties(stackDepth, contextId);
    }

    public boolean configureStderr(int value) throws DbgpException {
        return this.streamCommands.configureStderr(value);
    }

    public boolean configureStdout(int value) throws DbgpException {
        return this.streamCommands.configureStdout(value);
    }

    public IDbgpProperty getProperty(String name) throws DbgpException {
        return this.propertyCommands.getProperty(name);
    }

    public IDbgpProperty getProperty(String name, int stackDepth) throws DbgpException {
        return this.propertyCommands.getProperty(name, stackDepth);
    }

    public IDbgpProperty getProperty(String name, int stackDepth, int contextId) throws DbgpException {
        return this.propertyCommands.getProperty(name, stackDepth, contextId);
    }

    public boolean setProperty(IDbgpProperty property) throws DbgpException {
        return this.propertyCommands.setProperty(property);
    }

    public boolean setProperty(String name, int stackDepth, String value) throws DbgpException {
        return this.propertyCommands.setProperty(name, stackDepth, value);
    }

    public IDbgpProperty getPropertyByKey(String name, String key) throws DbgpException {
        return this.propertyCommands.getPropertyByKey(name, key);
    }

    public IDbgpProperty getProperty(int page, String name, int stackDepth) throws DbgpException {
        return this.propertyCommands.getProperty(page, name, stackDepth);
    }
}

