/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.ErrorReporter;
import com.xored.org.mozilla.javascript.EvaluatorException;
import com.xored.org.mozilla.javascript.IXMLCallback;
import com.xored.org.mozilla.javascript.Parser;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.javascript.internal.ui.text.Token;
import org.eclipse.dltk.javascript.internal.ui.text.XMLTokenizer;
import org.eclipse.dltk.ui.editor.highlighting.AbstractSemanticHighlighter;

final class JavaScriptPositionUpdater
extends AbstractSemanticHighlighter {
    private static final int HL_XML_TAG = 0;
    private static final int HL_XML_ATTRIBUTE = 1;
    private static final int HL_XML_COMMENT = 1;

    JavaScriptPositionUpdater() {
    }

    protected boolean doHighlighting(ISourceModule code) throws Exception {
        char[] sourceAsCharArray = code.getContentsAsCharArray();
        Parser p = new Parser(new CompilerEnvirons(), new ErrorReporter(){

            public void error(String message, String sourceName, int line, String lineSource, int offset) {
            }

            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                return null;
            }

            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            }
        });
        try {
            p.setXMLCallback(new IXMLCallback(){

                public void xmlTokenStart(int offset, String tagName, int cursor) {
                    int i = cursor - offset + 1;
                    if (tagName.length() != i) {
                        StringBuffer copy = new StringBuffer();
                        int a = 0;
                        while (a < tagName.length()) {
                            char c = tagName.charAt(a);
                            if (c == '\n') {
                                copy.append("  ");
                            } else {
                                copy.append(c);
                            }
                            ++a;
                        }
                        tagName = copy.toString();
                    }
                    XMLTokenizer r = new XMLTokenizer(new StringReader(tagName));
                    List l = r.getRegions();
                    int a = 0;
                    while (a < l.size()) {
                        Token object = (Token)l.get(a);
                        if (object.context == "5") {
                            JavaScriptPositionUpdater.this.addRange(offset - 1 + object.start, object.textLength, 0);
                        } else if (object.context == "28") {
                            JavaScriptPositionUpdater.this.addRange(offset - 1 + object.start, object.textLength, 1);
                        } else if (object.context == "16" || object.context == "8" || object.context == "17") {
                            JavaScriptPositionUpdater.this.addRange(offset - 1 + object.start, object.textLength, 1);
                        } else {
                            String cfr_ignored_0 = object.context;
                        }
                        ++a;
                    }
                }
            });
            p.parse((Reader)new CharArrayReader(sourceAsCharArray), ((Object)((Object)this)).toString(), 0);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void addRange(int start, int len, int highlightingIndex) {
        this.addPosition(start, start + len, highlightingIndex);
    }
}

