/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.SimpleClassDLTKExtensionManager;
import org.eclipse.dltk.core.SimpleDLTKExtensionManager;
import org.eclipse.dltk.ui.IModelCompareProvider;
import org.eclipse.dltk.ui.IModelContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;

public class UIModelProviderManager {
    private static final IModelCompareProvider[] NONE_MODEL_COMPARE_PROVIDERS = new IModelCompareProvider[0];
    private static final ILabelProvider[] NONE_LABEL_PROVIDERS = new ILabelProvider[0];
    private static final IModelContentProvider[] NONE_MODEL_CONTENT_PROVIDERS = new IModelContentProvider[0];
    private static final String REQUIRES = "requires";
    private static final String ID = "id";
    private static final String LANGUAGE = "language";
    private static SimpleClassDLTKExtensionManager contentProviderManager = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.ui.modelContentProvider");
    private static SimpleClassDLTKExtensionManager labelProviderManager = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.ui.modelLabelProvider");
    private static SimpleClassDLTKExtensionManager compareProviderManager = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.ui.modelCompareProvider");
    private static Map contentProviders = null;
    private static Map labelProviders = null;
    private static Map compareProviders = null;

    public static synchronized IModelContentProvider[] getContentProviders(String lang) {
        if (contentProviders == null) {
            contentProviders = UIModelProviderManager.initializeProviders(contentProviderManager);
        }
        if (lang == null) {
            ArrayList providers = new ArrayList();
            Collection values = contentProviders.values();
            for (List elements : values) {
                providers.addAll(elements);
            }
            return providers.toArray(new IModelContentProvider[providers.size()]);
        }
        List result = (List)contentProviders.get(lang);
        if (result != null) {
            return result.toArray(new IModelContentProvider[result.size()]);
        }
        return NONE_MODEL_CONTENT_PROVIDERS;
    }

    public static synchronized ILabelProvider[] getLabelProviders(String lang) {
        if (labelProviders == null) {
            labelProviders = UIModelProviderManager.initializeProviders(labelProviderManager);
        }
        if (lang == null) {
            ArrayList providers = new ArrayList();
            Collection values = labelProviders.values();
            for (List elements : values) {
                providers.addAll(elements);
            }
            return providers.toArray(new ILabelProvider[providers.size()]);
        }
        List result = (List)labelProviders.get(lang);
        if (result != null) {
            return result.toArray(new ILabelProvider[result.size()]);
        }
        return NONE_LABEL_PROVIDERS;
    }

    public static synchronized IModelCompareProvider[] getCompareProviders(String lang) {
        if (compareProviders == null) {
            compareProviders = UIModelProviderManager.initializeProviders(compareProviderManager);
        }
        if (lang == null) {
            ArrayList providers = new ArrayList();
            Collection values = compareProviders.values();
            for (List elements : values) {
                providers.addAll(elements);
            }
            return providers.toArray(new IModelCompareProvider[providers.size()]);
        }
        List result = (List)compareProviders.get(lang);
        if (result != null) {
            return result.toArray(new IModelCompareProvider[result.size()]);
        }
        return NONE_MODEL_COMPARE_PROVIDERS;
    }

    private static synchronized Map initializeProviders(SimpleClassDLTKExtensionManager manager) {
        HashMap providers = new HashMap();
        SimpleDLTKExtensionManager.ElementInfo[] infos = manager.getElementInfos();
        HashMap langToElementList = new HashMap();
        int i = 0;
        while (i < infos.length) {
            List<SimpleDLTKExtensionManager.ElementInfo> elements;
            String langauge = infos[i].getConfig().getAttribute(LANGUAGE);
            if (langToElementList.containsKey(langauge)) {
                elements = (List)langToElementList.get(langauge);
                elements.add(infos[i]);
            } else {
                elements = new ArrayList();
                elements.add(infos[i]);
                langToElementList.put(langauge, elements);
            }
            ++i;
        }
        for (Map.Entry entry : langToElementList.entrySet()) {
            String language = (String)entry.getKey();
            List elements = (List)entry.getValue();
            HashMap<String, SimpleDLTKExtensionManager.ElementInfo> names = new HashMap<String, SimpleDLTKExtensionManager.ElementInfo>();
            int i2 = 0;
            while (i2 < elements.size()) {
                SimpleDLTKExtensionManager.ElementInfo info = (SimpleDLTKExtensionManager.ElementInfo)elements.get(i2);
                String name = info.getConfig().getAttribute(ID);
                names.put(name, info);
                ++i2;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            HashSet<String> added = new HashSet<String>();
            ArrayList<SimpleDLTKExtensionManager.ElementInfo> toProcess = new ArrayList<SimpleDLTKExtensionManager.ElementInfo>();
            toProcess.addAll(elements);
            while (!toProcess.isEmpty()) {
                SimpleDLTKExtensionManager.ElementInfo info = (SimpleDLTKExtensionManager.ElementInfo)toProcess.remove(0);
                String requires = info.getConfig().getAttribute(REQUIRES);
                if (requires == null) {
                    result.add(manager.getInitObject(info));
                    continue;
                }
                String req = requires.trim();
                if (names.containsKey(req)) {
                    toProcess.add(info);
                    added.add(info.getConfig().getAttribute(ID));
                    continue;
                }
                result.add(info.object);
                added.add(info.getConfig().getAttribute(ID));
            }
            providers.put(language, result);
        }
        return providers;
    }
}

