/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal.rspec;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.dltk.ruby.ast.RubyASTUtil;
import org.eclipse.dltk.ruby.ast.RubyCallArgument;
import org.eclipse.dltk.ruby.internal.debug.ui.console.RubyFileHyperlink;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestRunnerUI;
import org.eclipse.dltk.ruby.testing.internal.AbstractTestingEngineValidateVisitor;
import org.eclipse.dltk.ruby.testing.internal.ResolverUtils;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingPlugin;
import org.eclipse.dltk.ruby.testing.internal.rspec.RSpecUtils;
import org.eclipse.dltk.ruby.testing.internal.rspec.RspecTestingEngine;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.TestElementResolution;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.dltk.testing.model.ITestSuiteElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;

public class RSpecTestRunnerUI
extends AbstractRubyTestRunnerUI {
    private static final char PATH_BEGIN = '<';
    private static final Pattern GEM_RSPEC_LIB = Pattern.compile(RSpecTestRunnerUI.buildRegex());
    static /* synthetic */ Class class$0;

    public RSpecTestRunnerUI(RspecTestingEngine testingEngine, IScriptProject project) {
        super(testingEngine, project);
    }

    public String getTestCaseLabel(ITestCaseElement caseElement, boolean full) {
        String testName = caseElement.getTestName();
        int index = testName.lastIndexOf(60);
        if (index >= 0) {
            if (full) {
                String template = DLTKTestingMessages.TestSessionLabelProvider_testMethodName_className;
                return NLS.bind((String)template, (Object)testName.substring(index + 1), (Object)testName.substring(0, index));
            }
            return testName.substring(0, index);
        }
        return testName;
    }

    public String getTestStartedMessage(ITestCaseElement caseElement) {
        String testName = caseElement.getTestName();
        int index = testName.lastIndexOf(60);
        if (index >= 0) {
            String template = DLTKTestingMessages.TestRunnerViewPart_message_started;
            return NLS.bind((String)template, (Object)testName.substring(index + 1), (Object)testName.substring(0, index));
        }
        return testName;
    }

    protected TestElementResolution resolveTestSuite(ITestSuiteElement element) {
        ITestElement[] children = element.getChildren();
        HashSet<String> locations = new HashSet<String>();
        int i = 0;
        while (i < children.length) {
            String location;
            Matcher matcher;
            ITestCaseElement caseElement;
            String testName;
            int index;
            if (children[i] instanceof ITestCaseElement && (index = (testName = (caseElement = (ITestCaseElement)children[i]).getTestName()).lastIndexOf(60)) > 0 && (matcher = STACK_FRAME_PATTERN.matcher(location = testName.substring(index + 1))).matches()) {
                locations.add(matcher.group(1));
            }
            ++i;
        }
        HashSet<IResource> processedResources = new HashSet<IResource>();
        RSpecContextLocator locator = new RSpecContextLocator(element.getSuiteTypeName());
        Iterator i2 = locations.iterator();
        while (i2.hasNext()) {
            ISourceModule module = this.findSourceModule((String)i2.next());
            if (module == null) continue;
            if (module.getResource() != null) {
                processedResources.add(module.getResource());
            }
            locator.process(module);
            if (locator.range == null) continue;
            return new TestElementResolution((IModelElement)module, locator.range);
        }
        IDLTKSearchScope scope = this.getSearchScope();
        TestElementResolution resolution = this.searchMethodReferences(scope, locator, "describe", processedResources);
        if (resolution != null) {
            return resolution;
        }
        resolution = this.searchMethodReferences(scope, locator, "context", processedResources);
        if (resolution != null) {
            return resolution;
        }
        return null;
    }

    private TestElementResolution searchMethodReferences(IDLTKSearchScope scope, RSpecContextLocator locator, String methodName, Set processedResources) {
        Set describeReferences = this.findMethodReferences(scope, methodName);
        describeReferences.removeAll(processedResources);
        Iterator i = describeReferences.iterator();
        while (i.hasNext()) {
            IResource resource = (IResource)i.next();
            if (!(resource instanceof IFile)) continue;
            IFile file = (IFile)resource;
            processedResources.add(file);
            ISourceModule module = (ISourceModule)DLTKCore.create((IFile)file);
            if (module == null) continue;
            locator.process(module);
            if (locator.range == null) continue;
            return new TestElementResolution((IModelElement)module, locator.range);
        }
        return null;
    }

    private Set findMethodReferences(IDLTKSearchScope scope, String methodName) {
        SearchPattern pattern = SearchPattern.createPattern((String)methodName, (int)1, (int)1, (int)8, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        MethodRequestor requestor = new MethodRequestor();
        try {
            new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
        }
        catch (CoreException e) {
            RubyTestingPlugin.error(NLS.bind((String)"Error in search method references {0})", (Object)methodName), e);
        }
        Set resources = requestor.resources;
        return resources;
    }

    protected TestElementResolution resolveTestCase(ITestCaseElement element) {
        IRegion line;
        int lineNumber;
        String source;
        if (!(element.getParentContainer() instanceof ITestSuiteElement)) {
            return null;
        }
        String testName = element.getTestName();
        int index = testName.lastIndexOf(60);
        if (index < 0) {
            return null;
        }
        String location = testName.substring(index + 1);
        Matcher matcher = STACK_FRAME_PATTERN.matcher(location);
        if (!matcher.matches()) {
            return null;
        }
        ISourceModule module = this.findSourceModule(matcher.group(1));
        if (module == null) {
            return null;
        }
        RSpecTestLocator locator = new RSpecTestLocator(((ITestSuiteElement)element.getParentContainer()).getSuiteTypeName(), testName.substring(0, index));
        locator.process(module);
        if (locator.range != null) {
            return new TestElementResolution((IModelElement)module, locator.range);
        }
        try {
            source = module.getSource();
        }
        catch (ModelException modelException) {
            return null;
        }
        DefaultLineTracker lineTracker = new DefaultLineTracker();
        lineTracker.set(source);
        try {
            lineNumber = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        try {
            line = lineTracker.getLineInformation(lineNumber - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return new TestElementResolution((IModelElement)module, ResolverUtils.adjustRange(source, line.getOffset(), line.getOffset() + line.getLength()));
    }

    private ISourceModule findSourceModule(String path) {
        IModelElement element;
        Object result = RubyFileHyperlink.findSourceModule((String)path);
        if (result instanceof ISourceModule) {
            return (ISourceModule)result;
        }
        if (result instanceof IFile && (element = DLTKCore.create((IFile)((IFile)result))) instanceof ISourceModule) {
            return (ISourceModule)element;
        }
        return null;
    }

    private static String buildRegex() {
        return "[\\\\/]gems[\\\\/]rspec-[\\w\\.]+[\\\\/]lib[\\\\/]";
    }

    protected boolean selectLine(String line) {
        String filename = this.extractFileName(line);
        if (filename == null) {
            return true;
        }
        if (filename.endsWith("dltk-rspec-runner.rb")) {
            return false;
        }
        return !GEM_RSPEC_LIB.matcher(filename).find();
    }

    public boolean canRerunFailures() {
        return true;
    }

    /*
     * Exception decompiling
     */
    public String collectFailures(ITestRunSession testRunSession) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 179->182)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class MethodRequestor
    extends SearchRequestor {
        final Set resources = new HashSet();

        private MethodRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getResource() != null) {
                this.resources.add(match.getResource());
            }
        }
    }

    static class RSpecContextLocator
    extends RSpecLocator {
        private final String contextName;
        private ISourceRange range = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.testing.internal.rspec.RSpecTestRunnerUI");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public RSpecContextLocator(String contextName) {
            this.contextName = contextName;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            CallArgumentsList args;
            CallExpression call;
            if (this.range == null && node instanceof CallExpression && this.isMethodCall(call = (CallExpression)node, RSpecUtils.CONTEXT_METHODS) && (args = call.getArgs()).getChilds().size() >= 1) {
                ArrayList texts = new ArrayList();
                ASTNode lastArg = this.collectArgs(args, texts);
                if (!texts.isEmpty() && this.isMatched(this.contextName, texts)) {
                    if (!$assertionsDisabled && lastArg == null) {
                        throw new AssertionError();
                    }
                    this.range = new SourceRange(call.sourceStart(), lastArg.sourceEnd() - call.sourceStart());
                }
            }
            return super.visitGeneral(node);
        }
    }

    private static class RSpecLocator
    extends AbstractTestingEngineValidateVisitor {
        private RSpecLocator() {
        }

        protected ASTNode collectArgs(CallArgumentsList args, List texts) {
            ASTNode lastArg = null;
            Iterator i = args.getChilds().iterator();
            while (i.hasNext()) {
                ASTNode value;
                String text;
                Object arg = i.next();
                if (!(arg instanceof RubyCallArgument) || (text = this.toText(value = ((RubyCallArgument)arg).getValue())) == null) continue;
                texts.add(text);
                lastArg = value;
            }
            return lastArg;
        }

        private String toText(ASTNode value) {
            if (value instanceof StringLiteral) {
                return ((StringLiteral)value).getValue().trim();
            }
            if (value instanceof NumericLiteral) {
                return ((NumericLiteral)value).getValue();
            }
            return RubyASTUtil.resolveReference((ASTNode)value);
        }

        protected boolean isMatched(String value, List texts) {
            StringBuffer sb = new StringBuffer();
            Iterator i = texts.iterator();
            while (i.hasNext()) {
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append(i.next());
            }
            return value.equals(sb.toString());
        }

        public void process(ISourceModule module) {
            ModuleDeclaration declaration = ResolverUtils.parse(module);
            if (declaration != null) {
                try {
                    declaration.traverse((ASTVisitor)this);
                }
                catch (Exception e) {
                    RubyTestingPlugin.error("Error in resolveTestSuite", e);
                }
            }
        }
    }

    private static class RSpecTestLocator
    extends RSpecLocator {
        private final String contextName;
        private final String testName;
        private ISourceRange range = null;
        private final Stack states = new Stack();
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.testing.internal.rspec.RSpecTestRunnerUI");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public RSpecTestLocator(String contextName, String testName) {
            this.contextName = contextName;
            this.testName = testName;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            CallExpression call;
            CallArgumentsList args;
            if (this.range == null && node instanceof CallExpression && (args = (call = (CallExpression)node).getArgs()).getChilds().size() >= 1) {
                if (this.isMethodCall(call, RSpecUtils.CONTEXT_METHODS)) {
                    boolean matched = false;
                    ArrayList texts = new ArrayList();
                    ASTNode lastArg = this.collectArgs(args, texts);
                    if (!texts.isEmpty() && this.isMatched(this.contextName, texts)) {
                        if (!$assertionsDisabled && lastArg == null) {
                            throw new AssertionError();
                        }
                        matched = true;
                    }
                    this.states.push(new State(node, matched));
                } else if (this.isMatchingContext() && this.isMethodCall(call, RSpecUtils.TEST_METHODS)) {
                    ArrayList texts = new ArrayList();
                    ASTNode lastArg = this.collectArgs(args, texts);
                    if (!texts.isEmpty() && this.isMatched(this.testName, texts)) {
                        if (!$assertionsDisabled && lastArg == null) {
                            throw new AssertionError();
                        }
                        this.range = new SourceRange(call.sourceStart(), lastArg.sourceEnd() - call.sourceStart());
                    }
                }
            }
            return super.visitGeneral(node);
        }

        private boolean isMatchingContext() {
            if (!this.states.isEmpty()) {
                State state = (State)this.states.peek();
                return state.isMatched;
            }
            return false;
        }

        public void endvisitGeneral(ASTNode node) throws Exception {
            if (!this.states.isEmpty()) {
                State state = (State)this.states.peek();
                if (state.callNode == node) {
                    this.states.pop();
                }
            }
            super.endvisitGeneral(node);
        }

        private static class State {
            final ASTNode callNode;
            final boolean isMatched;

            public State(ASTNode callNode, boolean isMatched) {
                this.callNode = callNode;
                this.isMatched = isMatched;
            }
        }
    }
}

