/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.processors;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclEnsemble;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclEnsemblePart;
import org.eclipse.dltk.itcl.internal.core.parser.processors.IncrTclUtils;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;

public class IncrTclEnsembleCommandProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        if (statement == null || statement != null && statement.getCount() == 0) {
            return null;
        }
        return this.processEnsemble(parent, statement, parser);
    }

    private ASTNode processEnsemble(ASTNode parent, TclStatement statement, ITclParser parser) {
        Expression classNameExpr = statement.getAt(1);
        Expression blockExpr = statement.getAt(2);
        if (classNameExpr instanceof SimpleReference) {
            IncrTclEnsemble ensamble = new IncrTclEnsemble(statement.sourceStart(), statement.sourceEnd());
            ensamble.setName(((SimpleReference)classNameExpr).getName());
            ensamble.setNameStart(classNameExpr.sourceStart());
            ensamble.setNameEnd(classNameExpr.sourceEnd());
            ensamble.setModifiers(0x200000);
            this.addToParent(parent, (ASTNode)ensamble);
            if (blockExpr instanceof TclBlockExpression) {
                TclBlockExpression block = (TclBlockExpression)blockExpr;
                List commands = block.parseBlockSimple(false);
                int i = 0;
                while (i < commands.size()) {
                    TclStatement st;
                    Expression commandName;
                    ASTNode nde = (ASTNode)commands.get(i);
                    if (nde instanceof TclStatement && (commandName = (st = (TclStatement)nde).getAt(0)) instanceof SimpleReference) {
                        String commandNameValue = ((SimpleReference)commandName).getName();
                        if (commandNameValue.equals("ensemble")) {
                            this.processEnsemble((ASTNode)ensamble, st, parser);
                        } else if (commandNameValue.equals("part")) {
                            this.processPart(ensamble, st, parser);
                        }
                    }
                    ++i;
                }
            } else {
                List expressions = statement.getExpressions();
                List subList = expressions.subList(2, expressions.size());
                TclStatement subSt = new TclStatement(subList);
                this.processPart(ensamble, subSt, parser);
            }
            return ensamble;
        }
        return null;
    }

    private void processPart(IncrTclEnsemble ensamble, TclStatement statement, ITclParser parser) {
        if (statement.getCount() < 2) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), 1);
            this.addToParent((ASTNode)ensamble, (ASTNode)statement);
            return;
        }
        Expression procName = statement.getAt(1);
        String sName = IncrTclUtils.extractMethodName(procName);
        if (sName == null || sName.length() == 0) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), 1);
            return;
        }
        Expression procArguments = null;
        Expression procCode = null;
        if (statement.getCount() >= 3) {
            procArguments = statement.getAt(2);
        }
        if (statement.getCount() == 4) {
            procCode = statement.getAt(3);
        }
        List arguments = IncrTclUtils.extractMethodArguments(procArguments);
        IncrTclEnsemblePart part = new IncrTclEnsemblePart(statement.sourceStart(), statement.sourceEnd());
        part.setName(sName);
        part.setNameStart(procName.sourceStart());
        part.setNameEnd(procName.sourceEnd());
        part.acceptArguments(arguments);
        part.setModifier(0x200000);
        if (procCode != null) {
            Block block = new Block(procCode.sourceStart(), procCode.sourceEnd());
            part.acceptBody(block);
            IncrTclUtils.parseAddToBlock(parser, procCode, block);
        }
        this.addToParent((ASTNode)ensamble, (ASTNode)part);
    }

    public void addToParent(ASTNode parent, ASTNode node) {
        IncrTclEnsemble ensemble;
        if (parent instanceof IncrTclEnsemble && node instanceof IncrTclEnsemble) {
            ensemble = (IncrTclEnsemble)parent;
            ensemble.addEnsamble((IncrTclEnsemble)node);
        }
        if (parent instanceof IncrTclEnsemble && node instanceof IncrTclEnsemblePart) {
            ensemble = (IncrTclEnsemble)parent;
            ensemble.addPart((IncrTclEnsemblePart)node);
        }
        super.addToParent(parent, node);
    }
}

