/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchRequestor;

public class TestSearchResults
extends SearchRequestor {
    private List matches = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        this.matches.add(match);
    }

    public int size() {
        return this.matches.size();
    }

    public void assertSourceModule(String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.ISourceModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertExists(clazz, name);
    }

    public void assertType(String name) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dltk.core.IType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertExists(clazz, name);
    }

    public void assertMethod(String name) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.dltk.core.IMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.assertExists(clazz, name);
    }

    public void assertExists(Class modelElementClass, String modelElementName) {
        if (this.locate(modelElementClass, modelElementName) == null) {
            Assert.fail((String)("Not found " + modelElementName + ":" + modelElementClass.getName()));
        }
    }

    public IModelElement locate(Class modelElementClass, String modelElementName) {
        Assert.assertNotNull((Object)modelElementClass);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.assertTrue((boolean)clazz.isAssignableFrom(modelElementClass));
        Iterator i = this.matches.iterator();
        while (i.hasNext()) {
            String matchName;
            SearchMatch match = (SearchMatch)i.next();
            if (!modelElementClass.isAssignableFrom(match.getElement().getClass())) continue;
            IModelElement element = (IModelElement)match.getElement();
            if (element instanceof IType) {
                IType type = (IType)element;
                matchName = type.getTypeQualifiedName("::");
            } else {
                matchName = element.getElementName();
            }
            if (!modelElementName.equals(matchName)) continue;
            return element;
        }
        return null;
    }
}

