/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Set;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.AbstractCallResultReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeObjectReference;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceFactory;

public class NewReference
extends AbstractCallResultReference {
    public NewReference(String name, String globalName, ReferenceResolverContext cs) {
        super(name, globalName, cs);
    }

    public String getResultId() {
        return "this";
    }

    public boolean isFunctionRef() {
        return false;
    }

    protected Set internalGetChilds(boolean resolveLocals) {
        if ("String".equals(this.getId())) {
            return ReferenceFactory.createStringReference("String").getChilds(resolveLocals);
        }
        if ("Date".equals(this.getId())) {
            return ReferenceFactory.createDateReference("Date").getChilds(resolveLocals);
        }
        if ("Array".equals(this.getId())) {
            return ReferenceFactory.createArrayReference("Array").getChilds(resolveLocals);
        }
        if ("Number".equals(this.getId())) {
            return ReferenceFactory.createNumberReference("Number").getChilds(resolveLocals);
        }
        if ("Boolean".equals(this.getId())) {
            return ReferenceFactory.createBooleanReference("Boolean").getChilds(resolveLocals);
        }
        if ("XML".equals(this.getId())) {
            return ReferenceFactory.createXMLReference("XML").getChilds(resolveLocals);
        }
        if (this.getId().startsWith("Packages.")) {
            String className = this.getId().substring("Packages.".length());
            try {
                Class<?> clz = Class.forName(className);
                NativeObjectReference ref = new NativeObjectReference(className, clz);
                return ref.getChilds(resolveLocals);
            }
            catch (Exception exception) {}
        }
        return super.internalGetChilds(resolveLocals);
    }
}

