/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.tcl.internal.ui.text.TclDocumentScanner;
import org.eclipse.dltk.tcl.internal.ui.text.TclPartitionScanner;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.utils.CharacterStack;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class TclAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private final IPreferenceStore preferenceStore;
    private final String fPartitioning;
    private static final int MAX_BACK_SCAN_SIZE = 16384;

    private boolean closeStrings() {
        return this.preferenceStore.getBoolean("closeStrings");
    }

    private boolean closeBrackets() {
        return this.preferenceStore.getBoolean("closeBrackets");
    }

    private boolean closeBraces() {
        return this.preferenceStore.getBoolean("closeBraces");
    }

    private boolean isSmartMode() {
        return this.preferenceStore.getBoolean("editorSmartIndent");
    }

    public int getPhysicalLength(String str) {
        int res = 0;
        int i = 0;
        while (i < str.length()) {
            res = str.charAt(i) == '\t' ? (res += this.getTabSize()) : ++res;
            ++i;
        }
        return res;
    }

    private int getTabSize() {
        return this.preferenceStore.getInt("formatter.tabulation.size");
    }

    private int getIndentSize() {
        return this.preferenceStore.getInt("formatter.indentation.size");
    }

    private String getTabStyle() {
        return this.preferenceStore.getString("formatter.tabulation.char");
    }

    private boolean isSmartPasteMode1() {
        return this.preferenceStore.getInt("smartPasteMode") == 1;
    }

    private boolean isSmartPasteMode2() {
        return this.preferenceStore.getInt("smartPasteMode") == 2;
    }

    public TclAutoEditStrategy(IPreferenceStore store, String part) {
        this.preferenceStore = store;
        this.fPartitioning = part;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private String getLineIndent(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    public String getLineIndent(String line) {
        int end;
        int whiteend = end = line.length();
        int offset = 0;
        while (offset < end) {
            char c = line.charAt(offset);
            if (c != ' ' && c != '\t') {
                whiteend = offset;
                break;
            }
            ++offset;
        }
        return line.substring(0, whiteend);
    }

    private char getBracePair(char b) {
        switch (b) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return b;
    }

    private TclBlock getLastOpenBlockType(IDocument d, int start) throws BadLocationException {
        CharacterStack blocks = new CharacterStack();
        ITypedRegion lastRegion = null;
        int lastLine = -1;
        int lastLineOffset = -1;
        String lastLineStr = "";
        int stopPosition = Math.max(start - 16384, 0);
        int offset = start;
        while (offset > stopPosition) {
            --offset;
            int bslashes = 0;
            while (offset - bslashes > 0 && d.getChar(offset - bslashes - 1) == '\\') {
                ++bslashes;
            }
            if (bslashes % 2 == 1) {
                offset -= bslashes;
                continue;
            }
            if (lastLineOffset < 0 || offset < lastLineOffset) {
                lastLine = d.getLineOfOffset(offset);
                lastLineOffset = d.getLineOffset(lastLine);
                lastLineStr = d.get(lastLineOffset, d.getLineLength(lastLine)).trim();
            }
            if (lastLineStr.length() != 0 && lastLineStr.charAt(0) == '#') {
                offset = lastLineOffset;
                continue;
            }
            if (lastRegion == null || offset < lastRegion.getOffset()) {
                lastRegion = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)offset, (boolean)true);
            }
            if (lastRegion.getType() == "__tcl_string") {
                offset = lastRegion.getOffset();
                --offset;
            }
            char c = d.getChar(offset);
            boolean insideFig = false;
            if (blocks.size() > 0 && blocks.peek() == '}') {
                insideFig = true;
            }
            if (c != '{' && c != '}' && insideFig) continue;
            switch (c) {
                case '(': {
                    if (blocks.size() == 0) {
                        return new RoundBracketBlock(offset);
                    }
                    if (blocks.pop() == ')') break;
                    return new RoundBracketBlock(offset);
                }
                case '[': {
                    if (blocks.size() == 0) {
                        return new BracketBlock(offset);
                    }
                    if (blocks.pop() == ']') break;
                    return new BracketBlock(offset);
                }
                case '{': {
                    if (blocks.size() == 0) {
                        return new BraceBlock(offset);
                    }
                    if (blocks.pop() == '}') break;
                    return new BraceBlock(offset);
                }
                case ')': 
                case ']': 
                case '}': {
                    blocks.push(c);
                }
            }
        }
        return null;
    }

    private int getLastCodeLine(IDocument d, int line) {
        int res = line;
        try {
            while (res > -1) {
                IRegion reg = d.getLineInformation(res);
                String str = d.get(reg.getOffset(), reg.getLength()).trim();
                if (!str.startsWith("#") && str.length() > 0) {
                    return res;
                }
                --res;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return res;
    }

    private String getDocumentLine(IDocument d, int line) throws BadLocationException {
        int start = d.getLineOffset(line);
        int length = d.getLineLength(line);
        return d.get(start, length);
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int lastCodeLine;
            TclDocumentScanner scanner = new TclDocumentScanner(d, this.fPartitioning, "__dftl_partition_content_type");
            int pos = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(pos);
            int curLine = d.getLineOfOffset(c.offset);
            String curLineStr = this.getDocumentLine(d, curLine);
            String resultIndent = "";
            String lastIndent = "";
            TclBlock block = null;
            boolean needPeer = false;
            boolean dummyPeer = false;
            block = this.getLastOpenBlockType(d, c.offset);
            if (curLineStr.trim().endsWith("\\")) {
                resultIndent = this.getLineIndent(d, line - 1);
            } else if (block == null) {
                lastCodeLine = this.getLastCodeLine(d, line);
                if (-1 == lastCodeLine) {
                    resultIndent = this.getLineIndent(d, line - 1);
                } else {
                    int peer;
                    block = this.getLastOpenBlockType(d, d.getLineOffset(lastCodeLine));
                    if (block != null && (peer = scanner.findOpeningPeer(d.getLineOffset(lastCodeLine), block.openingPeer, block.closingPeer)) != -1) {
                        lastCodeLine = d.getLineOfOffset(peer);
                    }
                    resultIndent = this.getLineIndent(d, lastCodeLine);
                }
            } else {
                int peerOffset;
                lastCodeLine = d.getLineOfOffset(block.getOffset());
                lastIndent = this.getLineIndent(d, lastCodeLine);
                resultIndent = String.valueOf(lastIndent) + block.indent;
                int cPos = pos;
                while (d.getChar(cPos) == ' ' || d.getChar(cPos) == '\t') {
                    if (cPos == d.getLength() - 1) break;
                    ++cPos;
                }
                if (block.closingPeer == d.getChar(cPos)) {
                    dummyPeer = true;
                }
                if ((peerOffset = scanner.findClosingPeer(pos, block.openingPeer, block.closingPeer)) == -1) {
                    needPeer = true;
                }
            }
            resultIndent = this.remakeIndent(resultIndent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            if (block instanceof BraceBlock && !this.preferenceStore.getBoolean("closeBraces")) {
                needPeer = false;
            }
            if ((block instanceof BracketBlock || block instanceof RoundBracketBlock) && !this.preferenceStore.getBoolean("closeBrackets")) {
                needPeer = false;
            }
            if (needPeer || dummyPeer) {
                StringBuffer buf = new StringBuffer(c.text);
                buf.append(resultIndent);
                c.shiftsCaret = false;
                c.caretOffset = c.offset + buf.length();
                if (lineEnd - contentStart > 0 && !dummyPeer) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append("\n");
                buf.append(lastIndent);
                if (!dummyPeer) {
                    buf.append(block.closingPeer);
                }
                c.text = buf.toString();
            } else {
                StringBuffer buf = new StringBuffer(c.text);
                buf.append(resultIndent);
                c.text = buf.toString();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1) {
            return;
        }
        try {
            if (d.getChar(c.offset - 1) == '\\') {
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
        if ('\"' == c.text.charAt(0) && !this.closeStrings()) {
            return;
        }
        if ('\'' == c.text.charAt(0) && !this.closeStrings()) {
            return;
        }
        if (!(this.closeBrackets() || '[' != c.text.charAt(0) && '(' != c.text.charAt(0))) {
            return;
        }
        if (!this.closeBraces() && '{' == c.text.charAt(0)) {
            return;
        }
        try {
            char ch = c.text.charAt(0);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if ('\"' == ch && c.offset > 0 && "\"".equals(d.get(c.offset - 1, 1))) {
                        return;
                    }
                    if ('\'' == ch && c.offset > 0 && "'".equals(d.get(c.offset - 1, 1))) {
                        return;
                    }
                    if (c.offset != d.getLength() && ch == d.get(c.offset, 1).charAt(0)) {
                        c.text = "";
                    } else {
                        c.text = String.valueOf(c.text) + c.text;
                        c.length = 0;
                    }
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + 1;
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    boolean needPeer = false;
                    TclDocumentScanner scanner = new TclDocumentScanner(d, this.fPartitioning, "__dftl_partition_content_type");
                    int peerOffset = scanner.findClosingPeer(c.offset, ch, this.getBracePair(ch));
                    if (peerOffset == -1) {
                        needPeer = true;
                    }
                    if (this.getRegionType(d, c.offset) != "__dftl_partition_content_type") {
                        return;
                    }
                    if (!needPeer) {
                        return;
                    }
                    if (c.offset != d.getLength() && ch == d.get(c.offset, 1).charAt(0)) {
                        return;
                    }
                    c.text = String.valueOf(c.text) + this.getBracePair(ch);
                    c.length = 0;
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + 1;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        block12: {
            if (c.offset == -1 || d.getLength() == 0) {
                return;
            }
            try {
                char bracket = c.text.charAt(0);
                if (c.offset != d.getLength() && bracket == d.get(c.offset, 1).charAt(0) && this.getRegionType(d, c.offset) == "__dftl_partition_content_type" && (bracket == '}' && this.closeBraces() || (bracket == ')' || bracket == ']') && this.closeBrackets())) {
                    c.text = "";
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + 1;
                    return;
                }
                TclDocumentScanner scanner = new TclDocumentScanner(d);
                int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
                int line = d.getLineOfOffset(p);
                int start = d.getLineOffset(line);
                int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
                if (whiteend == c.offset) {
                    TclBlock block = null;
                    switch (c.text.charAt(0)) {
                        case ']': {
                            block = new BracketBlock(0);
                            break;
                        }
                        case '}': {
                            block = new BraceBlock(0);
                            break;
                        }
                        case ')': {
                            block = new RoundBracketBlock(0);
                        }
                    }
                    if (block == null) {
                        return;
                    }
                    int reference = scanner.findOpeningPeer(p, block.openingPeer, block.closingPeer);
                    int indLine = d.getLineOfOffset(reference);
                    if (indLine != -1 && indLine != line) {
                        StringBuffer replaceText = new StringBuffer();
                        replaceText.append(this.getLineIndent(d, indLine));
                        replaceText.append(c.text);
                        c.length += c.offset - start;
                        c.offset = start;
                        c.text = replaceText.toString();
                    }
                }
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG) break block12;
                e.printStackTrace();
            }
        }
    }

    private boolean smartIndentJump(IDocument d, DocumentCommand c) {
        String resultIndent;
        int line;
        block11: {
            block10: {
                if (c.offset == -1 || d.getLength() == 0) {
                    return false;
                }
                try {
                    int lastCodeLine;
                    TclDocumentScanner scanner = new TclDocumentScanner(d, this.fPartitioning, "__dftl_partition_content_type");
                    int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
                    int curLine = d.getLineOfOffset(c.offset);
                    String curLineStr = this.getDocumentLine(d, curLine);
                    line = d.getLineOfOffset(p);
                    int start = d.getLineOffset(line);
                    resultIndent = "";
                    String lastIndent = "";
                    TclBlock block = this.getLastOpenBlockType(d, c.offset);
                    if (curLineStr.trim().endsWith("\\")) {
                        resultIndent = this.getLineIndent(d, line - 1);
                    } else if (block == null) {
                        int peer;
                        lastCodeLine = this.getLastCodeLine(d, line);
                        block = this.getLastOpenBlockType(d, d.getLineOffset(curLine));
                        if (block != null && (peer = scanner.findOpeningPeer(d.getLineOffset(curLine), block.openingPeer, block.closingPeer)) != -1) {
                            lastCodeLine = d.getLineOfOffset(peer);
                        }
                        resultIndent = -1 == lastCodeLine ? this.getLineIndent(d, line - 1) : this.getLineIndent(d, lastCodeLine);
                    } else {
                        lastCodeLine = d.getLineOfOffset(block.getOffset());
                        lastIndent = this.getLineIndent(d, lastCodeLine);
                        resultIndent = String.valueOf(lastIndent) + block.indent;
                    }
                    if (c.offset < start + resultIndent.length()) break block10;
                    return false;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            String currentIndent = this.getLineIndent(d, line);
            if (currentIndent.startsWith(resultIndent)) break block11;
            return false;
        }
        c.length = 0;
        c.shiftsCaret = false;
        c.text = "";
        c.caretOffset = d.getLineOffset(line) + resultIndent.length();
        return true;
    }

    private static void installStuff(Document document) {
        String[] types = new String[]{"__tcl_string", "__tcl_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new TclPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__tcl_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeStuff(Document document) {
        document.setDocumentPartitioner("__tcl_partitioning", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void smartPasteSimple(IDocument d, DocumentCommand c) {
        try {
            String content = String.valueOf(d.get(0, c.offset)) + c.text;
            Document temp = new Document(content);
            int line = d.getLineOfOffset(c.offset);
            int start = d.getLineOffset(line);
            int relativeIndent = 0;
            int sline = line + 1;
            String commonIndent = this.getLineIndent(d, line);
            int back = -1;
            if (d.get(start, c.offset - start).trim().length() == 0) {
                int depth = 0;
                int i = 0;
                block9: while (i < c.text.length()) {
                    switch (c.text.charAt(i)) {
                        case '(': 
                        case '[': 
                        case '{': {
                            ++depth;
                            break;
                        }
                        case ')': 
                        case ']': 
                        case '}': {
                            --depth;
                            break;
                        }
                        case '\n': {
                            break block9;
                        }
                    }
                    ++i;
                }
                if (depth == 0 && i != c.text.length() && this.getRegionType((IDocument)temp, c.offset + i) != "__tcl_string") {
                    String first = this.getLineIndent(c.text.substring(0, i));
                    String second = this.getLineIndent((IDocument)temp, line + 1);
                    temp.replace(start, c.offset - start + first.length(), second);
                } else {
                    temp.replace(start, c.offset - start, "");
                }
                back = c.offset - start;
                relativeIndent = this.getPhysicalLength(this.getLineIndent((IDocument)temp, line));
                sline = line;
            }
            while (true) {
                try {
                    this.getDocumentLine((IDocument)temp, sline);
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
                String currentIndent = this.getLineIndent((IDocument)temp, sline);
                int newIndentLen = this.getPhysicalLength(commonIndent) + this.getPhysicalLength(currentIndent) - relativeIndent;
                String newIndent = this.generateIndent(newIndentLen);
                temp.replace(temp.getLineOffset(sline), currentIndent.length(), newIndent);
                ++sline;
            }
            if (back > 0) {
                c.offset = start;
                c.text = temp.get(start, temp.getLength() - start);
                c.length += back;
                return;
            }
            c.text = temp.get(c.offset, temp.getLength() - c.offset);
            return;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String generateIndent(int newIndentLen) {
        String res = "";
        if (!this.getTabStyle().equals("space")) {
            int ts = this.getTabSize();
            while (newIndentLen >= ts) {
                res = String.valueOf(res) + "\t";
                newIndentLen -= ts;
            }
        }
        if (this.getTabStyle().equals("tab")) {
            if (newIndentLen > 0) {
                res = String.valueOf(res) + "\t";
            }
        } else {
            int i = 0;
            while (i < newIndentLen) {
                res = String.valueOf(res) + " ";
                ++i;
            }
        }
        return res;
    }

    private String remakeIndent(String indent) {
        int len = this.getPhysicalLength(indent);
        return this.generateIndent(len);
    }

    private void smartPaste2(IDocument d, DocumentCommand cmd) {
        try {
            String content = String.valueOf(d.get(0, cmd.offset)) + cmd.text;
            Document temp = new Document(content);
            TclAutoEditStrategy.installStuff(temp);
            Vector<TclBlock> blocks = new Vector<TclBlock>();
            int figs = 0;
            int cmdLine = d.getLineOfOffset(cmd.offset);
            int cmdLineStart = d.getLineOffset(cmdLine);
            int startLine = d.getLineOfOffset(cmd.offset) + 1;
            if (d.get(cmdLineStart, cmd.offset - cmdLineStart).trim().length() == 0) {
                --startLine;
            }
            int offset = 0;
            while (offset < temp.getLength()) {
                ITypedRegion region = TextUtilities.getPartition((IDocument)temp, (String)this.fPartitioning, (int)offset, (boolean)true);
                if (region.getType() != "__dftl_partition_content_type" && figs == 0) {
                    offset = region.getOffset() + region.getLength();
                    continue;
                }
                char c = temp.getChar(offset);
                if (c == '\\') {
                    offset += 2;
                    continue;
                }
                switch (c) {
                    case ')': 
                    case ']': 
                    case '}': {
                        if (c == '}') {
                            --figs;
                        }
                        if (blocks.size() <= 0) break;
                        blocks.removeElementAt(blocks.size() - 1);
                    }
                }
                int line = temp.getLineOfOffset(offset);
                String currentIndent = this.getLineIndent((IDocument)temp, line);
                if (line >= startLine && offset == temp.getLineOffset(line) + currentIndent.length()) {
                    StringBuffer newIndentBuf = new StringBuffer();
                    Iterator iter = blocks.iterator();
                    while (iter.hasNext()) {
                        TclBlock b = (TclBlock)iter.next();
                        newIndentBuf.append(b.indent);
                    }
                    String newIndent = newIndentBuf.toString();
                    temp.replace(temp.getLineOffset(line), currentIndent.length(), newIndent);
                    offset = temp.getLineOffset(line) + newIndent.length();
                }
                switch (c) {
                    case '(': {
                        blocks.add(new RoundBracketBlock(offset));
                        break;
                    }
                    case '[': {
                        blocks.add(new BracketBlock(offset));
                        break;
                    }
                    case '{': {
                        ++figs;
                        blocks.add(new BraceBlock(offset));
                    }
                }
                ++offset;
            }
            cmd.text = temp.get(cmdLineStart, temp.getLength() - cmdLineStart);
            cmd.offset = cmdLineStart;
            TclAutoEditStrategy.removeStuff(temp);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String getRegionType(IDocument d, int offset) throws BadLocationException {
        ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)offset, (boolean)true);
        return region.getType();
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        block14: {
            block15: {
                block12: {
                    block13: {
                        if (!c.doit) {
                            return;
                        }
                        if (c.length != 0 || c.text == null || !this.isLineDelimiter(d, c.text)) break block12;
                        if (!this.isSmartMode()) break block13;
                        this.smartIndentAfterNewLine(d, c);
                        break block14;
                    }
                    super.customizeDocumentCommand(d, c);
                    return;
                }
                if (c.length > 1 || c.text.length() != 1) break block15;
                switch (c.text.charAt(0)) {
                    case ')': 
                    case ']': 
                    case '}': {
                        this.smartIndentAfterClosingBracket(d, c);
                        break;
                    }
                    case '\"': 
                    case '(': 
                    case '[': 
                    case '{': {
                        this.smartIndentAfterOpeningBracket(d, c);
                        break;
                    }
                    case '\t': {
                        boolean jumped = false;
                        if (this.preferenceStore.getBoolean("smart_tab")) {
                            jumped = this.smartIndentJump(d, c);
                        }
                        if (!jumped && this.getTabStyle().equals("space")) {
                            c.text = "";
                            int ts = this.getTabSize();
                            int i = 0;
                            while (i < ts) {
                                c.text = String.valueOf(c.text) + " ";
                                ++i;
                            }
                            break block0;
                        } else {
                            break;
                        }
                    }
                }
                break block14;
            }
            if (c.text.length() >= 1 && this.isSmartPasteMode1()) {
                this.smartPasteSimple(d, c);
            } else if (c.text.length() >= 1 && this.isSmartPasteMode2()) {
                this.smartPaste2(d, c);
            }
        }
    }

    private class BraceBlock
    extends TclBlock {
        public BraceBlock(int offset) {
            super(offset);
            this.openingPeer = (char)123;
            this.closingPeer = (char)125;
            this.indent = !TclAutoEditStrategy.this.getTabStyle().equals("space") ? "\t" : AutoEditUtils.getNSpaces((int)TclAutoEditStrategy.this.getIndentSize());
        }
    }

    private class BracketBlock
    extends TclBlock {
        public BracketBlock(int offset) {
            super(offset);
            this.openingPeer = (char)91;
            this.closingPeer = (char)93;
            this.indent = !TclAutoEditStrategy.this.getTabStyle().equals("tab") ? " " : "\t";
        }
    }

    private class RoundBracketBlock
    extends TclBlock {
        public RoundBracketBlock(int offset) {
            super(offset);
            this.openingPeer = (char)40;
            this.closingPeer = (char)41;
            this.indent = !TclAutoEditStrategy.this.getTabStyle().equals("tab") ? " " : "\t";
        }
    }

    private abstract class TclBlock {
        private int offset;
        public char openingPeer;
        public char closingPeer;
        public String indent;

        protected TclBlock(int o) {
            this.offset = o;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

